/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.gnuplot;

import com.panayotis.gnuplot.PropertiesHolder;
import com.panayotis.gnuplot.layout.GraphLayout;
import com.panayotis.gnuplot.plot.Axis;
import com.panayotis.gnuplot.plot.Graph;
import com.panayotis.gnuplot.plot.Graph3D;
import com.panayotis.gnuplot.plot.Page;
import com.panayotis.gnuplot.plot.Plot;
import com.panayotis.gnuplot.terminal.GNUPlotTerminal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GNUPlotParameters
extends PropertiesHolder
implements Serializable {
    private Page page;
    private int defaultgraph;
    private List<String> preinit;
    private List<String> postinit;

    public GNUPlotParameters() {
    }

    public GNUPlotParameters(boolean isGraph3D) {
        this.page = new Page(isGraph3D);
        this.defaultgraph = 0;
        this.preinit = new ArrayList<String>();
        this.postinit = new ArrayList<String>();
    }

    public Axis getAxis(String axisname) {
        return ((Graph)this.page.get(this.defaultgraph)).getAxis(axisname);
    }

    public List<String> getPreInit() {
        return this.preinit;
    }

    public List<String> getPostInit() {
        return this.postinit;
    }

    public void addPlot(Plot plot) {
        ((Graph)this.page.get(this.defaultgraph)).add(plot);
    }

    public void newGraph() {
        this.addGraph(new Graph());
    }

    public void newGraph3D() {
        this.addGraph(new Graph3D());
    }

    public void addGraph(Graph gr) {
        this.page.add(gr);
        this.defaultgraph = this.page.size() - 1;
    }

    public void setMultiTitle(String title) {
        this.page.setTitle(title);
    }

    GraphLayout getLayout() {
        return this.page.getLayout();
    }

    public Page getPage() {
        return this.page;
    }

    public List<Plot> getPlots() {
        return (List)this.page.get(this.defaultgraph);
    }

    String getPlotCommands(GNUPlotTerminal term) {
        StringBuilder bf = new StringBuilder();
        for (String com : this.preinit) {
            bf.append(com).append(NL);
        }
        this.appendProperties(bf);
        if (!term.getType().equals("")) {
            bf.append("set term ").append(term.getType()).append(NL);
        }
        if (!term.getOutputFile().equals("")) {
            bf.append("set output '").append(term.getOutputFile()).append("'").append(NL);
        }
        for (String com : this.postinit) {
            bf.append(com).append(NL);
        }
        this.page.getGNUPlotPage(bf);
        bf.append("quit").append(NL);
        return bf.toString();
    }
}

