/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.gnuplot.dataset;

import com.panayotis.gnuplot.dataset.DataSet;
import com.panayotis.gnuplot.dataset.parser.DataParser;
import com.panayotis.gnuplot.dataset.parser.DoubleDataParser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericDataSet
implements DataSet,
Serializable {
    private final DataParser parser;
    private List<List<String>> data;

    public GenericDataSet() {
        this(new DoubleDataParser());
    }

    public GenericDataSet(boolean first_column_date) {
        this(new DoubleDataParser(first_column_date));
    }

    public GenericDataSet(DataParser parser) {
        this.parser = parser;
        this.data = new ArrayList<List<String>>();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public int getDimensions() {
        if (this.size() < 1) {
            return -1;
        }
        return this.data.get(0).size();
    }

    @Override
    public String getPointValue(int point, int dimension) {
        return this.data.get(point).get(dimension);
    }

    public boolean add(List<String> point) throws NumberFormatException {
        this.checkData(point, this.getDimensions());
        return this.data.add(point);
    }

    private int checkData(List<String> point, int old_dim) throws NumberFormatException {
        int new_dim = point.size();
        if (old_dim < 0) {
            old_dim = new_dim;
        }
        if (old_dim != new_dim) {
            throw new ArrayIndexOutOfBoundsException("Point inserted differs in dimension: found " + new_dim + ", requested " + old_dim);
        }
        for (int i = 0; i < point.size(); ++i) {
            if (this.parser.isValid(point.get(i), i)) continue;
            throw new NumberFormatException("The point added with value \"" + point.get(i) + "\" and index " + i + " is not valid with parser " + this.parser.getClass().getName());
        }
        return old_dim;
    }
}

