/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.gnuplot.layout;

import com.panayotis.gnuplot.layout.GraphLayout;
import com.panayotis.gnuplot.plot.Page;
import java.io.Serializable;

public class AutoGraphLayout
implements GraphLayout,
Serializable {
    public static final boolean DOWNWARDS = true;
    public static final boolean UPWARDS = false;
    public static final boolean ROWSFIRST = true;
    public static final boolean COLUMNSFIRST = false;
    private boolean orientation = true;
    private boolean drawfirst = true;
    private int rows = -1;
    private int cols = -1;

    public void setDrawFirst(boolean drawfirst) {
        this.drawfirst = drawfirst;
    }

    public void setOrientation(boolean orientation) {
        this.orientation = orientation;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public void setColumns(int cols) {
        this.cols = cols;
    }

    private int getOtherDimension(int size, int dim) {
        return (int)Math.ceil((double)size / (double)dim);
    }

    public void setDefinition(Page page, StringBuilder buffer) {
        int drawrows;
        int drawcols;
        int size = page.size();
        if (size <= 0) {
            return;
        }
        if (this.cols > 0 && this.rows > 0) {
            drawcols = this.cols;
            drawrows = this.rows;
        } else if (this.cols > 0) {
            drawcols = this.cols;
            drawrows = this.getOtherDimension(size, drawcols);
        } else if (this.rows > 0) {
            drawrows = this.rows;
            drawcols = this.getOtherDimension(size, drawrows);
        } else {
            drawrows = (int)Math.floor(Math.sqrt(size));
            drawcols = this.getOtherDimension(size, drawrows);
        }
        buffer.append(" layout ");
        buffer.append(drawrows).append(',').append(drawcols);
        if (this.drawfirst) {
            buffer.append(" rowsfirst");
        } else {
            buffer.append(" columnsfirst");
        }
        if (this.orientation) {
            buffer.append(" downwards");
        } else {
            buffer.append(" upwards");
        }
    }
}

