/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.gnuplot.plot;

import com.panayotis.gnuplot.PropertiesHolder;
import com.panayotis.gnuplot.plot.Plot;
import com.panayotis.gnuplot.style.PlotStyle;
import com.panayotis.gnuplot.style.Smooth;

public abstract class AbstractPlot
extends PropertiesHolder
implements Plot {
    private static int last_id = 0;
    private String definition = "";
    private PlotStyle style = null;
    private Smooth smooth = null;

    public AbstractPlot() {
        super(" ", "");
        this.setTitle("Datafile " + ++last_id);
    }

    protected void setDefinition(String definition) {
        this.definition = definition;
    }

    public void retrieveDefinition(StringBuilder buf) {
        buf.append(this.definition);
        this.appendProperties(buf);
        if (this.smooth != null) {
            buf.append(this.smooth.toString());
        }
        if (this.style != null) {
            this.style.appendProperties(buf);
        }
    }

    public void setPlotStyle(PlotStyle style) {
        this.style = style;
    }

    public PlotStyle getPlotStyle() {
        if (this.style == null) {
            this.style = new PlotStyle();
        }
        return this.style;
    }

    public void setSmooth(Smooth smooth) {
        this.smooth = smooth;
    }

    public final void setTitle(String title) {
        this.set("title", "\"" + title.replaceAll("[\"]", "\\\\\\\"") + "\"");
    }
}

