/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.gnuplot.plot;

import com.panayotis.gnuplot.layout.LayoutMetrics;
import com.panayotis.gnuplot.plot.Axis;
import com.panayotis.gnuplot.plot.Plot;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph
extends ArrayList<Plot> {
    protected static final String NL = System.getProperty("line.separator");
    private final HashMap<String, Axis> axis = new HashMap();
    private LayoutMetrics metrics;

    public Graph() {
        this.axis.put("x", new Axis("x"));
        this.axis.put("y", new Axis("y"));
        this.axis.put("z", new Axis("z"));
        this.metrics = null;
    }

    public Axis getAxis(String axisname) {
        if (axisname == null) {
            return null;
        }
        return this.axis.get(axisname.toLowerCase());
    }

    public void addPlot(Plot plot) {
        if (plot != null) {
            this.add(plot);
        }
    }

    void retrieveData(StringBuilder bf) {
        if (this.size() == 0) {
            return;
        }
        for (Axis ax : this.axis.values()) {
            ax.appendProperties(bf);
        }
        bf.append(this.getPlotCommand());
        for (Plot p : this) {
            bf.append(' ');
            p.retrieveDefinition(bf);
            bf.append(',');
        }
        bf.deleteCharAt(bf.length() - 1).append(NL);
        for (Plot p : this) {
            p.retrieveData(bf);
        }
    }

    public void setMetrics(float x, float y, float width, float height) {
        this.metrics = new LayoutMetrics(x, y, width, height);
    }

    public LayoutMetrics getMetrics() {
        return this.metrics;
    }

    protected String getPlotCommand() {
        return "plot";
    }
}

