/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.gnuplot.plot;

import com.panayotis.gnuplot.layout.AutoGraphLayout;
import com.panayotis.gnuplot.layout.GraphLayout;
import com.panayotis.gnuplot.layout.LayoutMetrics;
import com.panayotis.gnuplot.plot.Graph;
import com.panayotis.gnuplot.plot.Graph3D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Page
extends ArrayList<Graph> {
    private static final long serialVersionUID = 6485013309125515984L;
    protected static final String NL = System.getProperty("line.separator");
    private String pagetitle;
    private GraphLayout layout;

    public Page() {
        this(false);
    }

    public Page(boolean isGraph3D) {
        if (isGraph3D) {
            this.add(new Graph3D());
        } else {
            this.add(new Graph());
        }
        this.pagetitle = "";
        this.layout = new AutoGraphLayout();
    }

    public GraphLayout getLayout() {
        return this.layout;
    }

    public void setLayout(GraphLayout layout) {
        this.layout = layout;
    }

    public Object getTitle() {
        return this.pagetitle;
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        this.pagetitle = title;
    }

    public void getGNUPlotPage(StringBuilder bf) {
        if (this.size() > 1) {
            bf.append("set multiplot");
            if (!this.pagetitle.equals("")) {
                bf.append(" title \"").append(this.pagetitle).append('\"');
            }
            this.layout.setDefinition(this, bf);
            bf.append(NL);
            for (Graph gr : this) {
                LayoutMetrics metrics = gr.getMetrics();
                if (metrics != null) {
                    bf.append("set origin ").append(metrics.getX()).append(',').append(metrics.getY()).append(NL);
                    bf.append("set size ").append(metrics.getWidth()).append(',').append(metrics.getHeight()).append(NL);
                }
                gr.retrieveData(bf);
            }
            bf.append("unset multiplot").append(NL);
        } else {
            ((Graph)this.get(0)).retrieveData(bf);
        }
    }
}

