/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.gnuplot.style;

import com.panayotis.gnuplot.PropertiesHolder;
import com.panayotis.gnuplot.style.FillStyle;
import com.panayotis.gnuplot.style.PlotColor;
import com.panayotis.gnuplot.style.Style;

public class PlotStyle
extends PropertiesHolder {
    private Style type;
    private FillStyle fill = null;

    public PlotStyle() {
        this((Style)null);
    }

    public PlotStyle(Style style) {
        super(" ", "");
        this.setStyle(style);
    }

    public void setStyle(Style style) {
        this.type = style;
    }

    public void appendProperties(StringBuilder buf) {
        if (this.type != null) {
            buf.append(" with ").append(this.type.name().toLowerCase());
            super.appendProperties(buf);
            if (this.fill != null && this.type.filled) {
                this.fill.appendProperties(buf);
            }
        }
    }

    public void setLineWidth(int width) {
        if (width < 0) {
            this.unset("linewidth");
        } else {
            this.set("linewidth", String.valueOf(width));
        }
    }

    public void setPointSize(int width) {
        if (width < 0) {
            this.unset("pointsize");
        } else {
            this.set("pointsize", String.valueOf(width));
        }
    }

    public void setLineType(int type) {
        if (type < -1) {
            this.unset("linetype");
        } else {
            this.set("linetype", String.valueOf(type));
        }
    }

    public void setLineType(PlotColor col) {
        if (col == null) {
            this.unset("linetype");
        } else {
            this.set("linetype", col.getColor());
        }
    }

    public void setPointType(int type) {
        if (type < -1) {
            this.unset("pointtype");
        } else {
            this.set("pointtype", String.valueOf(type));
        }
    }

    public void setFill(FillStyle fillstyle) {
        this.fill = fillstyle;
    }
}

