/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.gnuplot.utils;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class Debug {
    public static final int QUIET = 0;
    public static final int CRITICAL = 10;
    public static final int ERROR = 20;
    public static final int WARNING = 30;
    public static final int INFO = 40;
    public static final int VERBOSE = 50;
    private static final String NL = System.getProperty("line.separator");
    private int level;
    private Writer out;

    public Debug() {
        this.setLevel(30);
        this.out = new BufferedWriter(new OutputStreamWriter(System.err));
    }

    public final void setLevel(int level) {
        this.level = level;
    }

    public void msg(String message, int level) {
        if (message == null || message.equals("")) {
            return;
        }
        if (level > 0 && level <= this.level) {
            try {
                this.out.write(message);
                if (!message.endsWith(NL)) {
                    this.out.write(NL);
                }
                this.out.flush();
            }
            catch (IOException ex) {
                System.out.println(ex.getMessage());
            }
        }
    }

    public void setWriter(Writer out) {
        if (out == null) {
            throw new NullPointerException("Debug: set of null output device.");
        }
        this.out = out;
    }
}

