package com.paymentplugins;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;


public abstract class JsonBuilder {

	private static String OPEN_BRACKET = "{";
	private static String CLOSE_BRACKET = "}";
	private static String OPEN_ARRAY = "[";
	private static String CLOSE_ARRAY = "]";
	private boolean isStart = true;
	
	public String buildJsonObject(String name){
		StringBuilder builder = new StringBuilder();
		if(name != null){
			builder.append(String.format("\"%s\" : ", name));
		}
		builder.append(OPEN_BRACKET);
		this.toJson(builder);
		builder.append(CLOSE_BRACKET);
		return builder.toString();
	}
	
	public void toJson(StringBuilder builder){
		Class klass = this.getClass();
		Field[] fields = klass.getDeclaredFields();
		for(Field field : fields){
			try{
				String json = null;
				field.setAccessible(true);
				Class klazz = field.getType();
				if(JsonBuilder.class.isAssignableFrom(klazz)){
					JsonBuilder handler = getHandlerFromField(field);
					json = handler.buildJsonObject(field.getName());
				}
				else if(List.class.isAssignableFrom(klazz)){
					json = this.buildJsonArray(field);
				}
				else{
					Annotation annotation = (Annotation) field.getAnnotation(Json.class);
					if(annotation != null){
						json = this.buildNameValuePair(field);
					} 
				}
				if(! isStart){
					builder.append(",");
				}
				if(json != null){
					builder.append(json);
					isStart = false;
				}
			} catch(Exception e){
				
			}
		}
	}
	
	private JsonBuilder getHandlerFromField(Field field) {
		JsonBuilder handler = null;
		try {
			handler = (JsonBuilder) field.get(this);
		} catch (IllegalArgumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return handler;
	}

	private String buildNameValuePair(Field field) throws Exception{
		String name = field.getName();
		String value;
		String nameValuePair = null;
		try {
			value = (String)field.get(this);
			if(value != null){
				return String.format("\"%s\" : \"%s\"", name, value);
			}
		} catch (IllegalArgumentException e) {
			throw new Exception(e.getMessage());
		} catch (IllegalAccessException e) {
			throw new Exception(e.getMessage());
		}
		return null;
	}
	
	private String buildJsonArray(Field field) throws Exception{
		StringBuilder builder = new StringBuilder(String.format("\"%s\" : ", field.getName()));
		builder.append(OPEN_ARRAY);
		String json;
		try {
			List list = (List)field.get(this);
			for(int i = 0; i < list.size(); i++){
				JsonBuilder handler = (JsonBuilder) list.get(i);
				json = handler.buildJsonObject(null);
				builder.append(json);
				if((i+1) != list.size()){
					builder.append(",");
				}
			}
		} catch (IllegalArgumentException e) {
			throw new Exception(e.getMessage());
		} catch (IllegalAccessException e) {
			throw new Exception(e.getMessage());
		}
		builder.append(CLOSE_ARRAY);
		return builder.toString();
	}
}
