package com.paymentplugins;

import java.util.Stack;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NodeHandler extends DefaultHandler{

	private Stack<SimpleXMLNode> stack = new Stack<SimpleXMLNode>();
	private SimpleXMLNode root;
	
	/**
	 * This method is called each time an xml node is found. 
	 */
	@Override
	public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
		//Add the qName to the XMLNode name. Add the node to the stack. Check if the stack is empty. If it is, then this is
		//the root element. 
		SimpleXMLNode node = new SimpleXMLNode(qName);
		//If the stack isn't empty, then add the node to its parent. 
		if(! this.stack.isEmpty()){
			this.stack.peek().addNode(node);
		}
		this.stack.push(node);
	}
	
	/**
	 * Add the value of the xml node to the XMLNode object. 
	 */
	@Override
	public void characters(char[] ch, int start, int length) throws SAXException {
		String value = new String(ch, start, length);
		if(value != null || !value.equals("")){
			this.stack.peek().addValue(value);
		}
	}
	
	@Override
	public void endElement(String uri, String localName, String qName) throws SAXException {
		SimpleXMLNode node = this.stack.pop();
		//If the stack is empty after the pop, then this node is the highest level node and should be assigned as root.
		if(this.stack.isEmpty()){
			this.root = node;
		}
	}
	
	public XMLNode getRoot(){
		return this.root;
	}
}
