/*
 * Decompiled with CFR 0.152.
 */
package com.paymentplugins;

import com.paymentplugins.Configuration;
import com.paymentplugins.HttpResponseException;
import com.paymentplugins.PaymentPluginsException;
import com.paymentplugins.SimpleXMLNode;
import com.paymentplugins.XMLNode;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.x500.X500Principal;
import javax.xml.bind.DatatypeConverter;

public class Http {
    private Configuration config;
    private static double JAVA_VERSION = Http.getJavaVersion();

    public Http(Configuration config) {
        this.config = config;
    }

    public XMLNode processRequest(String uri, Method method) {
        return this.processRequest(uri, method, null);
    }

    public XMLNode processRequest(String uri, Method method, String body) {
        StringBuilder builder = new StringBuilder();
        HttpURLConnection connection = null;
        XMLNode node = null;
        try {
            int i;
            connection = this.buildConnection(uri, method.getMethod());
            if (connection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(this.generateSSLSocketFactory());
            }
            if (body != null) {
                connection.getOutputStream().write(body.getBytes());
            }
            int httpCode = connection.getResponseCode();
            this.checkResponseCode(httpCode);
            InputStream stream = connection.getInputStream();
            BufferedInputStream buff = new BufferedInputStream(stream);
            while ((i = buff.read()) != -1) {
                builder.append((char)i);
            }
            node = SimpleXMLNode.parse(builder.toString());
        }
        catch (IOException e) {
            throw new PaymentPluginsException(e.getMessage());
        }
        catch (Exception e) {
            throw new PaymentPluginsException(e.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return node;
    }

    private SSLSocketFactory generateSSLSocketFactory() {
        String certPath = this.config.getCert();
        InputStream certStream = null;
        ClassLoader cl = Http.class.getClassLoader();
        certStream = cl.getResourceAsStream(certPath);
        SSLSocketFactory sf = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> collection = cf.generateCertificates(certStream);
            for (Certificate certificate : collection) {
                if (!(certificate instanceof X509Certificate)) continue;
                X500Principal principal = ((X509Certificate)certificate).getSubjectX500Principal();
                String alias = principal.getName();
                keyStore.setCertificateEntry(alias, certificate);
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, null);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            SSLContext sslContext = null;
            sslContext = this.getSSLContext();
            sslContext.init(kmf.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
            sf = sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new PaymentPluginsException(e.getMessage());
        }
        finally {
            if (certStream != null) {
                try {
                    certStream.close();
                }
                catch (IOException e) {
                    throw new PaymentPluginsException(e.getMessage());
                }
            }
        }
        return sf;
    }

    private HttpURLConnection buildConnection(String uri, String method) throws Exception {
        HttpURLConnection connection = null;
        String url = this.config.getBaseUrl() + uri;
        try {
            URL connectionUrl = new URL(url);
            connection = (HttpURLConnection)connectionUrl.openConnection();
            connection.setRequestMethod(method);
            connection.addRequestProperty("Authorization", this.getAuthorizationHeader());
            connection.addRequestProperty("Content-Type", "application/json");
            connection.addRequestProperty("Accept", "application/xml");
            connection.setDoOutput(true);
            connection.setConnectTimeout(60000);
        }
        catch (MalformedURLException e) {
            throw new Exception("MalformedURLException: " + e.getMessage());
        }
        catch (IOException e) {
            throw new Exception("IOException: " + e.getMessage());
        }
        return connection;
    }

    private SSLContext getSSLContext() throws NoSuchAlgorithmException {
        SSLContext sslContext = null;
        sslContext = JAVA_VERSION < 1.7 ? SSLContext.getInstance("TLSv1.1") : SSLContext.getInstance("TLSv1.2");
        return sslContext;
    }

    private String getAuthorizationHeader() {
        byte[] auths = (this.config.getPublickey() + ":" + this.config.getPrivatekey()).getBytes();
        String authorizations = DatatypeConverter.printBase64Binary((byte[])auths);
        String authHeader = String.format("Basic %s", authorizations);
        return authHeader;
    }

    private void checkResponseCode(int httpCode) {
        HTTP_CODE codeType = this.isResponseCodeError(httpCode);
        if (codeType != null) {
            throw new HttpResponseException(codeType.getMessage());
        }
    }

    private HTTP_CODE isResponseCodeError(int httpCode) {
        for (Error error : Error.values()) {
            if (error.getCode() != httpCode) continue;
            return error;
        }
        return null;
    }

    private static double getJavaVersion() {
        String version = System.getProperty("java.version");
        double v = 0.0;
        if (version.startsWith("1.8")) {
            v = 1.8;
        } else if (version.startsWith("1.7")) {
            v = 1.7;
        } else if (version.startsWith("1.6")) {
            v = 1.6;
        } else if (version.startsWith("1.5")) {
            v = 1.5;
        }
        return v;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Error implements HTTP_CODE
    {
        SC_BAD_REQUEST(400, "Bad Request"),
        SC_UNAUTHORIZED(401, "Unauthorized "),
        SC_FORBIDDEN(403, "Forbidden"),
        SC_NOT_FOUND(404, "Not Found"),
        SC_METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
        SC_INTERNAL_SERVER_ERROR(500, "Server Error"),
        SC_NOT_IMPLEMENTED(501, "Not Implemented"),
        SC_BAD_GATEWAY(502, "Bad Gateway"),
        SC_SERVICE_UNAVAILABLE(503, "Service Unavailable"),
        SC_GATEWAY_TIMEOUT(504, "Gateway Timeout");

        private int code;
        private String message;

        private Error(int code, String message) {
            this.code = code;
            this.message = message;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Success implements HTTP_CODE
    {
        SC_OK(200, "OK"),
        SC_CREATED(201, "Created"),
        SC_ACCEPTED(202, "Accepted"),
        SC_NON_AUTHORITATIVE_INFORMATION(203, "Non Authoritative Information"),
        SC_NO_CONTENT(204, "No Content");

        private int code;
        private String message;

        private Success(int code, String message) {
            this.code = code;
            this.message = message;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public static interface HTTP_CODE {
        public int getCode();

        public String getMessage();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Method {
        GET("GET"),
        POST("POST");

        private String method;

        private Method(String method) {
            this.method = method;
        }

        public String getMethod() {
            return this.method;
        }
    }
}

