package com.paystack.android_sdk.ui.data

import com.paystack.android_sdk.core.Paystack
import com.paystack.android_sdk.core.api.transactions
import com.paystack.android_sdk.ui.data.transaction.TransactionRepository
import com.paystack.android_sdk.ui.data.transaction.TransactionRepositoryImpl

internal fun dataComponent() = DataModule(Paystack.Builder.instance.build())

internal interface DataComponent {
    val transactionRepository: TransactionRepository
}

internal class DataModule constructor(private val paystack: Paystack) : DataComponent {
    override val transactionRepository: TransactionRepository
        get() = TransactionRepositoryImpl(paystack.transactions)
}
