package com.paystack.android_sdk.ui.paymentchannels.card.auth.address

import com.paystack.android_sdk.core.api.models.AddressState

data class AddressFormState(
    val streetAddress: String = "",
    val zipCode: String = "",
    val city: String = "",
    val selectedStateIndex: Int? = null,
    val stateList: List<AddressState> = emptyList(),
    val isSubmitting: Boolean = false,
    val isLoadingStates: Boolean = false
) {
    val isFormValid: Boolean
        get() = streetAddress.isNotEmpty() &&
            zipCode.isNotEmpty() &&
            city.isNotEmpty() &&
            selectedStateIndex != null

    val selectedStateCode: String?
        get() = selectedStateIndex?.let { stateList[it].abbreviation }
}
