package com.paystack.android_sdk.ui.paymentchannels.card.auth.phone

import android.os.Parcelable
import kotlinx.parcelize.Parcelize

@Parcelize
data class PhoneNumberAuthState(
    val phoneNumber: String = "",
    val isSubmitting: Boolean = false,
) : Parcelable {
    val isValid: Boolean
        get() = phoneNumber.length >= PHONE_NUMBER_MIN_LENGTH

    companion object {
        const val PHONE_NUMBER_MIN_LENGTH = 10
    }
}
