package com.paystack.android_sdk.ui.paymentchannels.card.model.local

enum class TransactionStatus(val value: String) {
    SUCCESS("success"),
    FAILED("failed"),
    PENDING("pending"),
    TIMEOUT("timeout"),
    SEND_OTP("send_otp"),
    SEND_BIRTHDAY("send_birthday"),
    SEND_PIN("send_pin"),
    SEND_PHONE("send_phone"),
    SEND_ADDRESS("send_address"),
    REDIRECT("redirect"), // 3ds,
    UNKNOWN("unknown_payment_type");

    companion object {
        fun from(status: String): TransactionStatus =
            values().find { it.value == status } ?: UNKNOWN
    }
}
