/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.client.rest;

import com.pdfdancer.client.rest.PDFDancer;
import com.pdfdancer.common.model.Color;
import com.pdfdancer.common.model.Font;
import com.pdfdancer.common.model.Position;
import com.pdfdancer.common.model.TextStatus;
import com.pdfdancer.common.model.TextTypeObjectRef;
import com.pdfdancer.common.model.text.Paragraph;
import com.pdfdancer.common.model.text.TextLine;
import com.pdfdancer.common.util.ParagraphUtil;
import java.io.File;
import java.util.stream.Collectors;

public class ParagraphBuilder {
    private static final double DEFAULT_LINE_SPACING_FACTOR = 1.2;
    private static final Color DEFAULT_TEXT_COLOR = new Color(0, 0, 0);
    private final Paragraph paragraph = new Paragraph();
    private final PDFDancer client;
    private Double lineSpacing;
    private Color textColor;
    private String text;
    private File ttfFile;
    private Font font;
    private boolean fontExplicitlyChanged = false;
    private Position originalParagraphPosition;

    public ParagraphBuilder(PDFDancer client) {
        this.client = client;
    }

    public boolean onlyTextChanged() {
        return this.textColor == null && this.ttfFile == null && this.font == null && this.lineSpacing == null;
    }

    public ParagraphBuilder text(String text) {
        this.text = text;
        return this;
    }

    public ParagraphBuilder text(String text, Color color) {
        this.text = text;
        this.textColor = color;
        return this;
    }

    public ParagraphBuilder font(Font font) {
        this.font = font;
        this.ttfFile = null;
        return this;
    }

    public ParagraphBuilder font(String fontName, double fontSize) {
        return this.font(new Font(fontName, fontSize));
    }

    public void setFontExplicitlyChanged(boolean fontExplicitlyChanged) {
        this.fontExplicitlyChanged = fontExplicitlyChanged;
    }

    public void setOriginalParagraphPosition(Position originalPosition) {
        this.originalParagraphPosition = originalPosition;
    }

    public ParagraphBuilder lineSpacing(double spacing) {
        this.lineSpacing = spacing;
        return this;
    }

    public ParagraphBuilder color(Color color) {
        this.textColor = color;
        return this;
    }

    public ParagraphBuilder at(Position pos) {
        this.paragraph.setPosition(pos);
        return this;
    }

    public ParagraphBuilder at(int pageIndex, double x, double y) {
        this.paragraph.setPosition(Position.atPageCoordinates(pageIndex, x, y));
        return this;
    }

    public boolean add() {
        return this.client.addParagaph(this.finalizeParagraph());
    }

    protected Paragraph finalizeParagraph() {
        if (this.text != null) {
            if (this.textColor == null) {
                this.textColor = DEFAULT_TEXT_COLOR;
            }
            if (this.lineSpacing == null) {
                this.lineSpacing = 1.2;
            }
            ParagraphUtil.finalizeText(this.text, this.paragraph, this.textColor, this.lineSpacing, this.font, TextStatus.fromParagraph(this.paragraph));
        } else {
            if (this.font != null) {
                this.paragraph.setFont(this.font);
            }
            if (this.lineSpacing != null) {
                this.paragraph.setLineSpacings(this.paragraph.getLines().stream().map(l -> this.lineSpacing).collect(Collectors.toUnmodifiableList()));
            }
            this.paragraph.getLines().forEach(line -> {
                if (this.textColor != null) {
                    line.setColor(this.textColor);
                }
                if (this.font != null && this.fontExplicitlyChanged) {
                    line.setFontName(this.font.getName());
                    line.setFontSize(this.font.getSize());
                    line.getTextElements().forEach(elem -> elem.setFont(this.font));
                }
            });
        }
        Position pPos = this.paragraph.getPosition();
        if (pPos != null && !this.paragraph.getLines().isEmpty()) {
            double baseY;
            double baseX;
            if (this.originalParagraphPosition != null) {
                baseX = this.originalParagraphPosition.getX();
                baseY = this.originalParagraphPosition.getY();
            } else if (this.paragraph.getLines().get(0).getPosition() != null) {
                baseX = this.paragraph.getLines().get(0).getPosition().getX();
                baseY = this.paragraph.getLines().get(0).getPosition().getY();
            } else {
                return this.paragraph;
            }
            double dx = pPos.getX() - baseX;
            double dy = pPos.getY() - baseY;
            this.paragraph.getLines().forEach(line -> {
                if (line.getPosition() != null) {
                    line.getPosition().atPosition(line.getPosition().getX() + dx, line.getPosition().getY() + dy);
                }
            });
        }
        return this.paragraph;
    }

    public ParagraphBuilder font(File ttfFile, double fontSize) {
        if (!ttfFile.exists()) {
            throw new IllegalArgumentException("TTF file does not exist");
        }
        if (!ttfFile.isFile()) {
            throw new IllegalArgumentException("TTF file is not a file");
        }
        if (!ttfFile.canRead()) {
            throw new IllegalArgumentException("TTF file is not readable");
        }
        this.ttfFile = ttfFile;
        this.font = this.registerTTF(ttfFile, fontSize);
        return this;
    }

    private Font registerTTF(File ttfFile, double fontSize) {
        return new Font(this.client.registerFont(ttfFile), fontSize);
    }

    public String getText() {
        return this.text;
    }

    public void addTextLine(TextTypeObjectRef text) {
        TextLine textLine = TextLine.fromObjectRef(text);
        this.paragraph.addLine(textLine);
    }
}

