/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.client.rest;

import com.pdfdancer.client.rest.BaseReference;
import com.pdfdancer.client.rest.PDFDancer;
import com.pdfdancer.client.rest.ParagraphBuilder;
import com.pdfdancer.common.model.Color;
import com.pdfdancer.common.model.Font;
import com.pdfdancer.common.model.ObjectRef;
import com.pdfdancer.common.model.Position;
import com.pdfdancer.common.model.TextTypeObjectRef;

public class TextParagraphReference
extends BaseReference {
    public TextParagraphReference(TextTypeObjectRef objectRef, PDFDancer client) {
        super(client, objectRef);
    }

    private TextTypeObjectRef ref() {
        return (TextTypeObjectRef)this.objectRef;
    }

    public String getText() {
        return this.ref().getText();
    }

    public String getFontName() {
        return this.ref().getFontName();
    }

    public Double getFontSize() {
        return this.ref().getFontSize();
    }

    public Color getColor() {
        return this.ref().getColor();
    }

    public TextEdit edit() {
        return new TextEdit(this.client, this.ref());
    }

    public static class TextEdit {
        private final PDFDancer client;
        private final TextTypeObjectRef ref;
        private String newText;
        private Font newFont;
        private Double newLineSpacing;
        private Position newPosition;
        private Color newColor;

        public TextEdit(PDFDancer client, TextTypeObjectRef ref) {
            this.client = client;
            this.ref = ref;
        }

        public TextEdit replace(String newText) {
            this.newText = newText;
            return this;
        }

        public TextEdit font(String fontName, double fontSize) {
            this.newFont = new Font(fontName, fontSize);
            return this;
        }

        public TextEdit lineSpacing(double spacing) {
            this.newLineSpacing = spacing;
            return this;
        }

        public TextEdit moveTo(double x, double y) {
            this.newPosition = Position.atPageCoordinates(this.ref.getPosition().getPageIndex(), x, y);
            return this;
        }

        public TextEdit color(Color color) {
            this.newColor = color;
            return this;
        }

        public boolean apply() {
            boolean fontExplicitlyChanged;
            if (this.newPosition == null && this.newLineSpacing == null && this.newFont == null && this.newColor == null) {
                String textToUse = this.newText != null ? this.newText : this.ref.getText();
                return this.client.modifyParagraph((ObjectRef)this.ref, textToUse);
            }
            ParagraphBuilder builder = new ParagraphBuilder(this.client);
            if (this.newText == null) {
                builder.setOriginalParagraphPosition(this.ref.getPosition());
                this.ref.getChildren().forEach(child -> {
                    if (child != null) {
                        builder.addTextLine((TextTypeObjectRef)child);
                    }
                });
            } else {
                builder.text(this.newText);
            }
            boolean bl = fontExplicitlyChanged = this.newFont != null;
            if (fontExplicitlyChanged) {
                builder.font(this.newFont);
                builder.setFontExplicitlyChanged(true);
            } else if (this.ref.getFontName() != null && this.ref.getFontSize() != null) {
                builder.font(this.ref.getFontName(), (double)this.ref.getFontSize());
            }
            if (this.newLineSpacing != null) {
                builder.lineSpacing(this.newLineSpacing);
            } else if (this.newText == null && this.ref.getLineSpacings() != null && !this.ref.getLineSpacings().isEmpty()) {
                double avgSpacing = this.ref.getLineSpacings().stream().mapToDouble(Double::doubleValue).average().orElse(1.2);
                builder.lineSpacing(avgSpacing);
            }
            if (this.newPosition != null) {
                builder.at(this.newPosition);
            } else if (this.ref.getPosition() != null) {
                builder.at(this.ref.getPosition());
            }
            if (this.newColor != null) {
                builder.color(this.newColor);
            } else if (this.ref.getColor() != null) {
                builder.color(this.ref.getColor());
            }
            return this.client.modifyParagraph((ObjectRef)this.ref, builder.finalizeParagraph());
        }
    }
}

