/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.common.model;

import com.pdfdancer.common.model.BoundingRect;
import com.pdfdancer.common.model.Point;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Position {
    private String name;
    private Integer pageIndex;
    private ShapeType shape;
    private PositionMode mode;
    private BoundingRect boundingRect;
    private String textStartsWith;
    private String textPattern;

    public Position() {
    }

    public Position(Integer pageIndex, BoundingRect boundingRect, PositionMode mode) {
        this.pageIndex = pageIndex;
        this.boundingRect = boundingRect;
        this.mode = mode;
    }

    public Position(double x, double y) {
        this.mode = PositionMode.CONTAINS;
        this.shape = ShapeType.POINT;
        this.boundingRect = new BoundingRect(x, y, 0.0, 0.0);
    }

    public static Position atPage(int pageIndex) {
        return new Position(pageIndex, null, PositionMode.CONTAINS);
    }

    public static Position atPageCoordinates(int pageIndex, double x, double y) {
        Position position = Position.atPage(pageIndex);
        position.atPosition(new Point(x, y));
        return position;
    }

    public static Position byName(String elementName) {
        return new Position().withName(elementName);
    }

    private Position withName(String elementName) {
        this.name = elementName;
        return this;
    }

    public void atPosition(Point point2D) {
        this.mode = PositionMode.CONTAINS;
        this.shape = ShapeType.POINT;
        this.boundingRect = new BoundingRect(point2D.x(), point2D.y(), 0.0, 0.0);
    }

    public String getTextStartsWith() {
        return this.textStartsWith;
    }

    public void setTextStartsWith(String textStartsWith) {
        this.textStartsWith = textStartsWith;
    }

    public void moveX(double xOffset) {
        this.atPosition(new Point(this.getX() + xOffset, this.getY()));
    }

    public void moveY(double yOffset) {
        this.atPosition(new Point(this.getX(), this.getY() + yOffset));
    }

    public Position atPosition(double x, double y) {
        this.atPosition(new Point(x, y));
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTextPattern() {
        return this.textPattern;
    }

    public void setTextPattern(String pattern) {
        this.textPattern = pattern;
    }

    public boolean textMatches(String text) {
        Pattern p = Pattern.compile(this.textPattern, 32);
        Matcher m = p.matcher(text);
        return m.matches();
    }

    public Position copy() {
        Position p = new Position(this.pageIndex, this.boundingRect, this.mode);
        p.textStartsWith = this.textStartsWith;
        p.shape = this.shape;
        p.textPattern = this.textPattern;
        return p;
    }

    public Double getX() {
        if (this.getBoundingRect() == null) {
            return null;
        }
        return this.getBoundingRect().getX();
    }

    public Double getY() {
        if (this.getBoundingRect() == null) {
            return null;
        }
        return this.getBoundingRect().getY();
    }

    public String toString() {
        return "Position{pageIndex=" + this.pageIndex + ", shape=" + String.valueOf((Object)this.shape) + ", mode=" + String.valueOf((Object)this.mode) + ", boundingRect=" + String.valueOf(this.boundingRect) + "}";
    }

    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public ShapeType getShape() {
        return this.shape;
    }

    public void setShape(ShapeType shape) {
        this.shape = shape;
    }

    public PositionMode getMode() {
        return this.mode;
    }

    public void setMode(PositionMode mode) {
        this.mode = mode;
    }

    public BoundingRect getBoundingRect() {
        return this.boundingRect;
    }

    public void setBoundingRect(BoundingRect boundingRect) {
        this.boundingRect = boundingRect;
    }

    public static enum ShapeType {
        POINT,
        LINE,
        CIRCLE,
        RECT;

    }

    public static enum PositionMode {
        INTERSECT,
        CONTAINS;

    }
}

