/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.common.model;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.pdfdancer.common.model.Color;
import com.pdfdancer.common.model.ObjectRef;
import com.pdfdancer.common.model.ObjectType;
import com.pdfdancer.common.model.Position;
import com.pdfdancer.common.model.TextStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class TextTypeObjectRef
extends ObjectRef {
    private final String fontName;
    private final Double fontSize;
    private final List<Double> lineSpacings;
    private final List<TextTypeObjectRef> children;
    private final Color color;
    private final String text;
    private final TextStatus status;

    @JsonCreator
    public TextTypeObjectRef(@JsonProperty(value="internalId") String internalId, @JsonProperty(value="position") Position position, @JsonProperty(value="type") @JsonAlias(value={"objectRefType"}) ObjectType type, @JsonProperty(value="objectRefType") ObjectType objectRefType, @JsonProperty(value="fontName") String fontName, @JsonProperty(value="fontSize") Double fontSize, @JsonProperty(value="text") String text, @JsonProperty(value="lineSpacings") List<Double> lineSpacings, @JsonProperty(value="color") Color color, @JsonProperty(value="status") TextStatus status, @JsonProperty(value="children") List<TextTypeObjectRef> children) {
        super(internalId, position, objectRefType, type);
        this.fontName = fontName;
        this.fontSize = fontSize;
        this.text = text;
        this.lineSpacings = lineSpacings != null ? new ArrayList<Double>(lineSpacings) : new ArrayList();
        this.color = color;
        this.status = status;
        this.children = children != null ? new ArrayList<TextTypeObjectRef>(children) : new ArrayList();
    }

    public String getText() {
        if (this.text == null) {
            return this.children.stream().map(TextTypeObjectRef::getText).collect(Collectors.joining("\n"));
        }
        return this.text;
    }

    public String getFontName() {
        return this.fontName;
    }

    public Double getFontSize() {
        return this.fontSize;
    }

    public List<Double> getLineSpacings() {
        return this.lineSpacings;
    }

    public List<TextTypeObjectRef> getChildren() {
        return this.children;
    }

    public Color getColor() {
        return this.color;
    }

    public void addChild(TextTypeObjectRef child) {
        this.children.add(child);
    }

    public TextStatus getStatus() {
        return this.status;
    }
}

