/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.client.http;

import com.pdfdancer.client.http.MediaType;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public final class MultipartBody {
    private final List<Part> parts;
    private final String boundary;

    private MultipartBody(List<Part> parts, String boundary) {
        this.parts = parts;
        this.boundary = boundary;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<Part> parts() {
        return this.parts;
    }

    public String boundary() {
        return this.boundary;
    }

    public static final class Builder {
        private final List<Part> parts = new ArrayList<Part>();

        public Builder addPart(String name, String fileName, MediaType contentType, byte[] content) {
            this.parts.add(new Part(name, fileName, contentType, content));
            return this;
        }

        public Builder addPart(String name, String value) {
            this.parts.add(Part.forText(name, value));
            return this;
        }

        public MultipartBody build() {
            if (this.parts.isEmpty()) {
                throw new IllegalStateException("Multipart body must contain at least one part");
            }
            String boundary = "----PdfDancerBoundary" + String.valueOf(UUID.randomUUID());
            return new MultipartBody(Collections.unmodifiableList(new ArrayList<Part>(this.parts)), boundary);
        }
    }

    public static final class Part {
        private final String name;
        private final String fileName;
        private final MediaType contentType;
        private final byte[] content;

        public Part(String name, String fileName, MediaType contentType, byte[] content) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(contentType, "contentType");
            Objects.requireNonNull(content, "content");
            this.name = name;
            this.fileName = fileName;
            this.contentType = contentType;
            this.content = content;
        }

        public static Part forText(String name, String value) {
            return new Part(name, null, MediaType.TEXT_PLAIN_TYPE, value.getBytes(StandardCharsets.UTF_8));
        }

        public String name() {
            return this.name;
        }

        public String fileName() {
            return this.fileName;
        }

        public MediaType contentType() {
            return this.contentType;
        }

        public byte[] content() {
            return this.content;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Part that = (Part)obj;
            return Objects.equals(this.name, that.name) && Objects.equals(this.fileName, that.fileName) && Objects.equals(this.contentType, that.contentType) && Arrays.equals(this.content, that.content);
        }

        public int hashCode() {
            int result = Objects.hash(this.name, this.fileName, this.contentType);
            result = 31 * result + Arrays.hashCode(this.content);
            return result;
        }

        public String toString() {
            return "Part[name=" + this.name + ", fileName=" + this.fileName + ", contentType=" + String.valueOf(this.contentType) + ", content=" + Arrays.toString(this.content) + "]";
        }
    }
}

