/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.common.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.pdfdancer.common.model.Orientation;
import com.pdfdancer.common.model.PageSize;
import java.util.Objects;

public final class CreateBlankPdfRequest {
    @JsonProperty(value="pageSize")
    private final PageSize pageSize;
    @JsonProperty(value="orientation")
    private final Orientation orientation;
    @JsonProperty(value="initialPageCount")
    private final Integer initialPageCount;

    @JsonCreator
    public CreateBlankPdfRequest(@JsonProperty(value="pageSize") PageSize pageSize, @JsonProperty(value="orientation") Orientation orientation, @JsonProperty(value="initialPageCount") Integer initialPageCount) {
        this.pageSize = pageSize;
        this.orientation = orientation;
        this.initialPageCount = initialPageCount;
    }

    public PageSize pageSize() {
        return this.pageSize != null ? this.pageSize : PageSize.A4;
    }

    public Orientation orientation() {
        return this.orientation != null ? this.orientation : Orientation.PORTRAIT;
    }

    public Integer initialPageCount() {
        return this.initialPageCount != null ? this.initialPageCount : 1;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CreateBlankPdfRequest that = (CreateBlankPdfRequest)obj;
        return Objects.equals(this.pageSize, that.pageSize) && Objects.equals((Object)this.orientation, (Object)that.orientation) && Objects.equals(this.initialPageCount, that.initialPageCount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.pageSize, this.orientation, this.initialPageCount});
    }

    public String toString() {
        return "CreateBlankPdfRequest[pageSize=" + String.valueOf(this.pageSize) + ", orientation=" + String.valueOf((Object)this.orientation) + ", initialPageCount=" + this.initialPageCount + "]";
    }
}

