/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.common.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.pdfdancer.common.model.Color;
import com.pdfdancer.common.request.RedactTarget;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class RedactRequest {
    @JsonProperty(value="targets")
    private final List<RedactTarget> targets;
    @JsonProperty(value="defaultReplacement")
    private final String defaultReplacement;
    @JsonProperty(value="placeholderColor")
    private final Color placeholderColor;

    @JsonCreator
    public RedactRequest(@JsonProperty(value="targets") List<RedactTarget> targets, @JsonProperty(value="defaultReplacement") String defaultReplacement, @JsonProperty(value="placeholderColor") Color placeholderColor) {
        this.targets = targets != null ? List.copyOf(targets) : List.of();
        this.defaultReplacement = defaultReplacement;
        this.placeholderColor = placeholderColor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<RedactTarget> targets() {
        return this.targets;
    }

    public String defaultReplacement() {
        return this.defaultReplacement;
    }

    public Color placeholderColor() {
        return this.placeholderColor;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RedactRequest that = (RedactRequest)obj;
        return Objects.equals(this.targets, that.targets) && Objects.equals(this.defaultReplacement, that.defaultReplacement) && Objects.equals(this.placeholderColor, that.placeholderColor);
    }

    public int hashCode() {
        return Objects.hash(this.targets, this.defaultReplacement, this.placeholderColor);
    }

    public String toString() {
        return "RedactRequest[targets=" + String.valueOf(this.targets) + ", defaultReplacement=" + this.defaultReplacement + ", placeholderColor=" + String.valueOf(this.placeholderColor) + "]";
    }

    public static class Builder {
        private final List<RedactTarget> targets = new ArrayList<RedactTarget>();
        private String defaultReplacement = "[REDACTED]";
        private Color placeholderColor = Color.BLACK;

        public Builder defaultReplacement(String defaultReplacement) {
            this.defaultReplacement = defaultReplacement;
            return this;
        }

        public Builder placeholderColor(Color placeholderColor) {
            this.placeholderColor = placeholderColor;
            return this;
        }

        public Builder addTarget(RedactTarget target) {
            this.targets.add(target);
            return this;
        }

        public Builder addTargetById(String id) {
            return this.addTargetById(id, null);
        }

        public Builder addTargetById(String id, String replacement) {
            this.targets.add(new RedactTarget(id, replacement));
            return this;
        }

        public RedactRequest build() {
            return new RedactRequest(this.targets, this.defaultReplacement, this.placeholderColor);
        }
    }
}

