/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.client.rest;

import java.time.Duration;
import java.util.HashSet;
import java.util.Set;

public final class RetryConfig {
    private final int maxAttempts;
    private final Duration initialDelay;
    private final double backoffMultiplier;
    private final Duration maxDelay;
    private final Set<Integer> retryableStatusCodes;
    private final boolean retryOnTimeout;
    private final boolean retryOnConnectionError;

    private RetryConfig(Builder builder) {
        this.maxAttempts = builder.maxAttempts;
        this.initialDelay = builder.initialDelay;
        this.backoffMultiplier = builder.backoffMultiplier;
        this.maxDelay = builder.maxDelay;
        this.retryableStatusCodes = new HashSet<Integer>(builder.retryableStatusCodes);
        this.retryOnTimeout = builder.retryOnTimeout;
        this.retryOnConnectionError = builder.retryOnConnectionError;
    }

    public static RetryConfig noRetry() {
        return RetryConfig.builder().maxAttempts(1).build();
    }

    public static RetryConfig defaultConfig() {
        return RetryConfig.builder().maxAttempts(3).initialDelay(Duration.ofSeconds(1L)).backoffMultiplier(2.0).maxDelay(Duration.ofSeconds(5L)).retryOnStatus(408, 429, 500, 502, 503, 504).retryOnTimeout(true).retryOnConnectionError(true).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public Duration getInitialDelay() {
        return this.initialDelay;
    }

    public double getBackoffMultiplier() {
        return this.backoffMultiplier;
    }

    public Duration getMaxDelay() {
        return this.maxDelay;
    }

    public Set<Integer> getRetryableStatusCodes() {
        return Set.copyOf(this.retryableStatusCodes);
    }

    public boolean isRetryOnTimeout() {
        return this.retryOnTimeout;
    }

    public boolean isRetryOnConnectionError() {
        return this.retryOnConnectionError;
    }

    public boolean isRetryableStatusCode(int statusCode) {
        return this.retryableStatusCodes.contains(statusCode);
    }

    public static final class Builder {
        private int maxAttempts = 1;
        private Duration initialDelay = Duration.ofMillis(100L);
        private double backoffMultiplier = 2.0;
        private Duration maxDelay = Duration.ofSeconds(10L);
        private Set<Integer> retryableStatusCodes = new HashSet<Integer>();
        private boolean retryOnTimeout = false;
        private boolean retryOnConnectionError = false;

        private Builder() {
        }

        public Builder maxAttempts(int maxAttempts) {
            if (maxAttempts < 1) {
                throw new IllegalArgumentException("maxAttempts must be at least 1");
            }
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Builder initialDelay(Duration initialDelay) {
            if (initialDelay == null || initialDelay.isNegative()) {
                throw new IllegalArgumentException("initialDelay must be non-null and non-negative");
            }
            this.initialDelay = initialDelay;
            return this;
        }

        public Builder backoffMultiplier(double backoffMultiplier) {
            if (backoffMultiplier < 1.0) {
                throw new IllegalArgumentException("backoffMultiplier must be at least 1.0");
            }
            this.backoffMultiplier = backoffMultiplier;
            return this;
        }

        public Builder maxDelay(Duration maxDelay) {
            if (maxDelay == null || maxDelay.isNegative()) {
                throw new IllegalArgumentException("maxDelay must be non-null and non-negative");
            }
            this.maxDelay = maxDelay;
            return this;
        }

        public Builder retryOnStatus(int ... statusCodes) {
            for (int code : statusCodes) {
                this.retryableStatusCodes.add(code);
            }
            return this;
        }

        public Builder retryOnTimeout(boolean retryOnTimeout) {
            this.retryOnTimeout = retryOnTimeout;
            return this;
        }

        public Builder retryOnConnectionError(boolean retryOnConnectionError) {
            this.retryOnConnectionError = retryOnConnectionError;
            return this;
        }

        public RetryConfig build() {
            return new RetryConfig(this);
        }
    }
}

