/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.common.model;

import com.pdfdancer.common.model.ObjectType;
import com.pdfdancer.common.model.PDFObject;
import com.pdfdancer.common.model.Position;
import com.pdfdancer.common.model.Size;
import com.pdfdancer.common.util.ImageInfo;
import java.io.File;
import java.io.IOException;

public class Image
extends PDFObject {
    private String format;
    private Size size;
    private byte[] data;

    public Image() {
    }

    public Image(String id, String format, Size size, Position position, byte[] data) {
        super(id, position);
        this.format = format;
        this.size = size;
        this.data = data;
    }

    public static Image fromFile(File file) throws IOException {
        ImageInfo read = ImageInfo.read(file);
        Image image = new Image();
        image.setData(read.bytes());
        image.setSize(new Size(read.width(), read.height()));
        image.setFormat(read.format());
        return image;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Size getSize() {
        return this.size;
    }

    public void setSize(Size size) {
        this.size = size;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.IMAGE;
    }
}

