/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.common.model;

import com.pdfdancer.common.model.DocumentFontInfoDto;
import com.pdfdancer.common.model.FontType;
import com.pdfdancer.common.model.text.Paragraph;
import com.pdfdancer.common.model.text.TextElement;
import com.pdfdancer.common.model.text.TextLine;
import java.util.Objects;
import java.util.stream.Stream;

public class TextStatus {
    private boolean isModified = false;
    private boolean isEncodable = true;
    private FontType fontType;
    private DocumentFontInfoDto fontInfo;

    public TextStatus(boolean isModified, boolean isEncodable, FontType fontType, DocumentFontInfoDto fontInfo) {
        this();
        this.isModified = isModified;
        this.isEncodable = isEncodable;
        this.fontType = fontType;
        this.fontInfo = fontInfo;
    }

    public TextStatus() {
    }

    public static TextStatus fromParagraph(Paragraph paragraph) {
        return TextStatus.accumulateTextStatus(paragraph.getLines().stream().flatMap(line -> line.getTextElements().stream()));
    }

    public static TextStatus fromTextLine(TextLine textLine) {
        return TextStatus.accumulateTextStatus(textLine.getTextElements().stream());
    }

    private static TextStatus accumulateTextStatus(Stream<TextElement> elements) {
        return elements.reduce(new TextStatus(), (status, elem) -> TextStatus.mergeStatus(status, elem.getStatus()), TextStatus::combineStatuses);
    }

    public static TextStatus mergeStatus(TextStatus base, TextStatus update) {
        if (update == null) {
            return base;
        }
        if (update.isModified()) {
            base.isModified = true;
        }
        if (!update.isEncodable()) {
            base.isEncodable = false;
        }
        if (base.getFontInfoDto() == null) {
            base.fontInfo = update.getFontInfoDto();
        }
        if (base.getFontType() == null) {
            base.fontType = update.getFontType();
        }
        return base;
    }

    public static TextStatus combineStatuses(TextStatus s1, TextStatus s2) {
        if (s2 == null) {
            return s1;
        }
        if (s1 == null) {
            return s2;
        }
        if (s2.isModified()) {
            s1.isModified = true;
        }
        if (!s2.isEncodable()) {
            s1.isEncodable = false;
        }
        if (s1.fontInfo == null) {
            s1.fontInfo = s2.fontInfo;
        }
        if (s1.fontType == null) {
            s1.fontType = s2.fontType;
        }
        return s1;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public boolean isEncodable() {
        return this.isEncodable;
    }

    public FontType getFontType() {
        return this.fontType;
    }

    public DocumentFontInfoDto getFontInfoDto() {
        return this.fontInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextStatus)) {
            return false;
        }
        TextStatus that = (TextStatus)o;
        return this.isModified == that.isModified && this.isEncodable == that.isEncodable && this.fontType == that.fontType && Objects.equals(this.fontInfo, that.fontInfo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isModified, this.isEncodable, this.fontType, this.fontInfo});
    }

    public String toString() {
        return "TextStatus[isModified=" + this.isModified + ", isEncodable=" + this.isEncodable + ", fontType=" + String.valueOf((Object)this.fontType) + ", fontInfo=" + String.valueOf(this.fontInfo) + "]";
    }

    public String getWarning() {
        if (!this.isEncodable() && this.fontInfo != null) {
            return "Text is not encodable with your current font, we are using'" + this.getFontInfoDto().systemFontName() + "' as a fallback font instead.";
        }
        if (this.isModified() && this.fontType.equals((Object)FontType.EMBEDDED)) {
            if (this.fontInfo != null && this.fontInfo.systemFontName() != null) {
                return null;
            }
            return "You are using an embedded font and modified the text. Even though the font reports to be able to render the new text, this is not guaranteed.\nPlease read https://docs.pdfdancer.com/notes/embedded-font-warning for more information and how to deal with this.";
        }
        return null;
    }
}

