/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.common.model.text;

import com.pdfdancer.common.model.Color;
import com.pdfdancer.common.model.Font;
import com.pdfdancer.common.model.ObjectType;
import com.pdfdancer.common.model.PDFObject;
import com.pdfdancer.common.model.Position;
import com.pdfdancer.common.model.TextStatus;
import com.pdfdancer.common.model.TextTypeObjectRef;
import java.util.Collections;

public class TextElement
extends PDFObject {
    private String text;
    private Font font;
    private Color color;
    private TextStatus status;

    public TextElement() {
    }

    public TextElement(String id, String text, Font font, Color color, Position position) {
        super(id, position);
        this.text = text;
        this.font = font;
        this.color = color;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.TEXT_ELEMENT;
    }

    public TextStatus getStatus() {
        return this.status;
    }

    public void setStatus(TextStatus status) {
        this.status = status;
    }

    @Override
    public TextTypeObjectRef toObjectRef() {
        return new TextTypeObjectRef(this.getId(), this.getPosition(), this.getObjectType(), this.getObjectType(), this.getFont().getName(), this.getFont().getSize(), this.getText(), Collections.emptyList(), this.getColor(), this.getStatus(), Collections.emptyList());
    }
}

