/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.common.util;

public enum StandardFonts {
    TIMES_ROMAN("Times-Roman"),
    TIMES_BOLD("Times-Bold"),
    TIMES_ITALIC("Times-Italic"),
    TIMES_BOLD_ITALIC("Times-BoldItalic"),
    HELVETICA("Helvetica"),
    HELVETICA_BOLD("Helvetica-Bold"),
    HELVETICA_OBLIQUE("Helvetica-Oblique"),
    HELVETICA_BOLD_OBLIQUE("Helvetica-BoldOblique"),
    COURIER("Courier"),
    COURIER_BOLD("Courier-Bold"),
    COURIER_OBLIQUE("Courier-Oblique"),
    COURIER_BOLD_OBLIQUE("Courier-BoldOblique"),
    SYMBOL("Symbol"),
    ZAPF_DINGBATS("ZapfDingbats");

    private final String fontName;

    private StandardFonts(String fontName) {
        this.fontName = fontName;
    }

    public static boolean isStandardFont(String name) {
        if (name == null) {
            return false;
        }
        String normalized = name.replaceAll("^[A-Z]{6}\\+", "");
        for (StandardFonts font : StandardFonts.values()) {
            if (!font.getFontName().equalsIgnoreCase(normalized)) continue;
            return true;
        }
        return false;
    }

    public String getFontName() {
        return this.fontName;
    }
}

