/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.common.util;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class UrlUtils {
    public static URL buildUrlWithPath(URL originalUrl, String newPath) throws URISyntaxException, MalformedURLException {
        String protocol = originalUrl.getProtocol();
        String host = originalUrl.getHost();
        int port = originalUrl.getPort();
        boolean includePort = !(port == -1 || protocol.equals("http") && port == 80 || protocol.equals("https") && port == 443);
        URI newUri = new URI(protocol, null, host, includePort ? port : -1, newPath, null, null);
        return newUri.toURL();
    }

    public static URL getRootUrl(URL originalUrl) throws URISyntaxException, MalformedURLException {
        return UrlUtils.buildUrlWithPath(originalUrl, "/");
    }

    public static URL getRootUrl(String originalUrl) throws URISyntaxException, MalformedURLException {
        return UrlUtils.buildUrlWithPath(new URI(originalUrl).toURL(), "/");
    }
}

