/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.common.util;

import com.pdfdancer.common.model.Color;
import com.pdfdancer.common.model.Font;
import com.pdfdancer.common.model.Position;
import com.pdfdancer.common.model.TextStatus;
import com.pdfdancer.common.model.text.Paragraph;
import com.pdfdancer.common.model.text.TextLine;
import com.pdfdancer.common.util.TextMeasurementUtil;
import java.util.ArrayList;

public class ParagraphUtil {
    public static void finalizeText(String text, Paragraph paragraph, Color color, double lineSpacingFactor, Font font, TextStatus status) {
        paragraph.clearLines();
        paragraph.setFont(font);
        if (text != null && !text.trim().isEmpty()) {
            String[] lines = text.split("\n");
            ArrayList<Double> lineSpacings = new ArrayList<Double>();
            for (int i = 0; i < lines.length; ++i) {
                Position linePosition = TextMeasurementUtil.calculateLinePosition(paragraph.getPosition(), i, font, lineSpacingFactor);
                paragraph.addLine(TextLine.fromText(lines[i], linePosition, color, font, status));
                if (i >= lines.length - 1) continue;
                lineSpacings.add(lineSpacingFactor);
            }
            paragraph.setLineSpacings(lineSpacings);
        }
    }
}

