/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.common.util;

import com.pdfdancer.common.model.Font;
import com.pdfdancer.common.model.Position;

public class TextMeasurementUtil {
    public static final double DEFAULT_LINE_SPACING_FACTOR = 1.2;

    public static double calculateBaselineDistance(Font font, double spacingFactor) {
        if (font == null) {
            return 14.399999999999999;
        }
        double factor = spacingFactor > 0.0 ? spacingFactor : 1.2;
        return font.getSize() * factor;
    }

    public static Position calculateLinePosition(Position paragraphPosition, int lineIndex, Font font, double spacingFactor) {
        if (paragraphPosition == null) {
            return null;
        }
        double baselineDistance = TextMeasurementUtil.calculateBaselineDistance(font, spacingFactor);
        double yOffset = (double)lineIndex * baselineDistance;
        Double paragraphX = paragraphPosition.getX();
        Double paragraphY = paragraphPosition.getY();
        if (paragraphX == null || paragraphY == null) {
            return new Position(0.0, yOffset);
        }
        return new Position(paragraphX, paragraphY + yOffset);
    }
}

