/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.client.rest;

import com.pdfdancer.client.rest.PDFDancer;
import com.pdfdancer.common.model.Color;
import com.pdfdancer.common.model.ObjectRef;
import com.pdfdancer.common.model.ObjectType;
import com.pdfdancer.common.model.Position;
import java.util.List;

public abstract class BaseReference {
    protected final PDFDancer client;
    protected final ObjectRef objectRef;

    public BaseReference(PDFDancer client, ObjectRef objectRef) {
        this.client = client;
        this.objectRef = objectRef;
    }

    public String getInternalId() {
        return this.objectRef.getInternalId();
    }

    public Position getPosition() {
        return this.objectRef.getPosition();
    }

    public boolean delete() {
        return this.client.delete(this.objectRef);
    }

    public boolean moveTo(double x, double y) {
        return this.client.move(this.objectRef, new Position(x, y));
    }

    public boolean moveX(int xOffset) {
        Position newPosition = this.objectRef.getPosition().copy();
        newPosition.moveX(xOffset);
        return this.client.move(this.objectRef, newPosition);
    }

    public boolean moveY(int yOffset) {
        Position newPosition = this.objectRef.getPosition().copy();
        newPosition.moveY(yOffset);
        return this.client.move(this.objectRef, newPosition);
    }

    public ObjectType type() {
        return this.objectRef.getType();
    }

    public boolean redact() {
        return this.redact("[REDACTED]", Color.BLACK);
    }

    public boolean redact(String replacement) {
        return this.redact(replacement, Color.BLACK);
    }

    public boolean redact(Color placeholderColor) {
        return this.redact("[REDACTED]", placeholderColor);
    }

    public boolean redact(String replacement, Color placeholderColor) {
        return this.client.redact(List.of(this), replacement, placeholderColor).success();
    }
}

