/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.client.rest;

import com.pdfdancer.client.http.Argument;
import com.pdfdancer.client.http.HttpRequest;
import com.pdfdancer.client.http.MediaType;
import com.pdfdancer.client.http.MultipartBody;
import com.pdfdancer.client.http.MutableHttpRequest;
import com.pdfdancer.client.rest.AnonTokenResponse;
import com.pdfdancer.client.rest.BaseReference;
import com.pdfdancer.client.rest.EnvironmentInfo;
import com.pdfdancer.client.rest.FormFieldReference;
import com.pdfdancer.client.rest.FormXObjectReference;
import com.pdfdancer.client.rest.ImageBuilder;
import com.pdfdancer.client.rest.ImageReference;
import com.pdfdancer.client.rest.PageBuilder;
import com.pdfdancer.client.rest.PageClientImpl;
import com.pdfdancer.client.rest.ParagraphBuilder;
import com.pdfdancer.client.rest.PathReference;
import com.pdfdancer.client.rest.PdfDancerHttpClient;
import com.pdfdancer.client.rest.SnapshotCache;
import com.pdfdancer.client.rest.TextLineReference;
import com.pdfdancer.client.rest.TextParagraphReference;
import com.pdfdancer.client.rest.TypedDocumentSnapshot;
import com.pdfdancer.client.rest.TypedPageSnapshot;
import com.pdfdancer.client.rest.mutation.ModificationService;
import com.pdfdancer.client.rest.selection.SelectionService;
import com.pdfdancer.client.rest.session.SessionService;
import com.pdfdancer.common.model.Color;
import com.pdfdancer.common.model.Font;
import com.pdfdancer.common.model.FormFieldRef;
import com.pdfdancer.common.model.Image;
import com.pdfdancer.common.model.ObjectRef;
import com.pdfdancer.common.model.ObjectType;
import com.pdfdancer.common.model.Orientation;
import com.pdfdancer.common.model.PDFObject;
import com.pdfdancer.common.model.PageRef;
import com.pdfdancer.common.model.PageSize;
import com.pdfdancer.common.model.Position;
import com.pdfdancer.common.model.TextTypeObjectRef;
import com.pdfdancer.common.model.text.Paragraph;
import com.pdfdancer.common.model.text.TextLine;
import com.pdfdancer.common.request.AddPageRequest;
import com.pdfdancer.common.request.CreateBlankPdfRequest;
import com.pdfdancer.common.request.FindRequest;
import com.pdfdancer.common.request.ImageTransformRequest;
import com.pdfdancer.common.request.RedactRequest;
import com.pdfdancer.common.request.TemplateReplaceRequest;
import com.pdfdancer.common.response.DocumentSnapshot;
import com.pdfdancer.common.response.PageSnapshot;
import com.pdfdancer.common.response.RedactResponse;
import com.pdfdancer.common.util.ExceptionUtils;
import com.pdfdancer.common.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class PDFDancer {
    public static final double DEFAULT_EPSILON = 0.01;
    private static final URI DEFAULT_BASE_URI = URI.create("https://api.pdfdancer.com");
    public static final String TYPES_PARAGRAPH = "PARAGRAPH";
    public static final String TYPES_TEXT_LINE = "TEXT_LINE";
    private final String token;
    private final String sessionId;
    private final PdfDancerHttpClient httpClient;
    private final PdfDancerHttpClient.Blocking blockingClient;
    private final SnapshotCache snapshotCache;
    private final SelectionService selection;
    private final ModificationService modification;

    private PDFDancer(String token, String sessionId, PdfDancerHttpClient client) {
        this.token = token;
        this.sessionId = sessionId;
        this.httpClient = client;
        this.blockingClient = client.toBlocking();
        this.snapshotCache = new SnapshotCache(token, sessionId, this.blockingClient);
        this.selection = new SelectionService();
        this.modification = new ModificationService(token, sessionId, this.blockingClient);
    }

    public static PDFDancer createSession(String token, File pdfFile) {
        return PDFDancer.createSession(token, PDFDancer.readFile(pdfFile), PDFDancer.getDefaultClient());
    }

    public static PDFDancer createSession(File pdfFile) {
        PdfDancerHttpClient client = PDFDancer.getDefaultClient();
        byte[] bytes = PDFDancer.readFile(pdfFile);
        String token = PDFDancer.envTokenOrNull();
        return token != null ? PDFDancer.createSession(token, bytes, client) : PDFDancer.createAnonSession(bytes, client);
    }

    public static PDFDancer createSession(String pdfFile) {
        return PDFDancer.createSession(new File(pdfFile));
    }

    public static PDFDancer createSession(String token, byte[] bytesPDF, PdfDancerHttpClient client) {
        String sessionId = PDFDancer.uploadPdfForSession(token, bytesPDF, client);
        return new PDFDancer(token, sessionId, client);
    }

    public static PDFDancer createSession(String token, byte[] bytesPDF, HttpClient httpClient) {
        return PDFDancer.createSession(token, bytesPDF, PdfDancerHttpClient.create(httpClient, PDFDancer.getBaseUrl()));
    }

    private static URI getBaseUrl() {
        String baseUrlValue = System.getProperty("pdfdancer.baseUrl", System.getenv().getOrDefault("PDFDANCER_BASE_URL", String.valueOf(DEFAULT_BASE_URI)));
        try {
            return new URI(baseUrlValue);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static PDFDancer createSession(String token, byte[] bytesPDF, HttpClient httpClient, URI baseUrl) {
        return PDFDancer.createSession(token, bytesPDF, PdfDancerHttpClient.create(httpClient, baseUrl));
    }

    public static PDFDancer createNew() {
        PdfDancerHttpClient client = PDFDancer.getDefaultClient();
        String token = PDFDancer.envTokenOrNull();
        if (token == null) {
            token = PDFDancer.obtainAnonymousToken(client);
        }
        return PDFDancer.createNew(token, PageSize.A4, Orientation.PORTRAIT, 1, client);
    }

    static PDFDancer createAnonSession(byte[] testPdf, PdfDancerHttpClient client) {
        String fingerprint = EnvironmentInfo.buildFingerprint();
        MutableHttpRequest<Object> request = HttpRequest.POST("/keys/anon", null).header("X-Fingerprint", fingerprint);
        AnonTokenResponse token = client.toBlocking().retrieve(request, AnonTokenResponse.class);
        return PDFDancer.createSession(token.token(), testPdf, client);
    }

    static PDFDancer createAnonSession(byte[] testPdf, HttpClient httpClient) {
        return PDFDancer.createAnonSession(testPdf, PdfDancerHttpClient.create(httpClient, PDFDancer.getBaseUrl()));
    }

    static PDFDancer createAnonSession(byte[] testPdf, HttpClient httpClient, URI baseUrl) {
        return PDFDancer.createAnonSession(testPdf, PdfDancerHttpClient.create(httpClient, baseUrl));
    }

    public static PDFDancer createNew(String token, PageSize pageSize, Orientation orientation, int initialPageCount) {
        return PDFDancer.createNew(token, pageSize, orientation, initialPageCount, PDFDancer.getDefaultClient());
    }

    public static PDFDancer createNew(PageSize pageSize, Orientation orientation, int initialPageCount) {
        PdfDancerHttpClient client = PDFDancer.getDefaultClient();
        String token = PDFDancer.envTokenOrNull();
        if (token == null) {
            token = PDFDancer.obtainAnonymousToken(client);
        }
        return PDFDancer.createNew(token, pageSize, orientation, initialPageCount, client);
    }

    public static PDFDancer createNew(String token, PageSize pageSize, Orientation orientation, int initialPageCount, PdfDancerHttpClient client) {
        String sessionId = PDFDancer.createBlankPdfSession(token, pageSize, orientation, initialPageCount, client);
        return new PDFDancer(token, sessionId, client);
    }

    public static PDFDancer createNew(String token, PageSize pageSize, Orientation orientation, int initialPageCount, HttpClient httpClient) {
        return PDFDancer.createNew(token, pageSize, orientation, initialPageCount, PdfDancerHttpClient.create(httpClient, PDFDancer.getBaseUrl()));
    }

    public static PDFDancer createNew(String token, PageSize pageSize, Orientation orientation, int initialPageCount, HttpClient httpClient, URI baseUrl) {
        return PDFDancer.createNew(token, pageSize, orientation, initialPageCount, PdfDancerHttpClient.create(httpClient, baseUrl));
    }

    private static PdfDancerHttpClient getDefaultClient() {
        return PdfDancerHttpClient.createDefault(PDFDancer.getBaseUrl());
    }

    private static String envTokenOrNull() {
        return EnvironmentInfo.envTokenOrNull();
    }

    private static String obtainAnonymousToken(PdfDancerHttpClient client) {
        return SessionService.obtainAnonymousToken(client);
    }

    private static String uploadPdfForSession(String token, byte[] pdf, PdfDancerHttpClient client) {
        return SessionService.uploadPdfForSession(token, pdf, client);
    }

    private static String createBlankPdfSession(String token, PageSize pageSize, Orientation orientation, int initialPageCount, PdfDancerHttpClient client) {
        return client.toBlocking().retrieve(HttpRequest.POST("/session/new", new CreateBlankPdfRequest(pageSize, orientation, initialPageCount)).contentType(MediaType.APPLICATION_JSON_TYPE).bearerAuth(token), String.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] readFile(File file) {
        try {
            FileInputStream inputStream = new FileInputStream(file);
            try {
                byte[] byArray = ((InputStream)Objects.requireNonNull(inputStream)).readAllBytes();
                return byArray;
            }
            catch (IOException e) {
                throw ExceptionUtils.wrapCheckedException(e);
            }
            finally {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
        catch (IOException e) {
            throw ExceptionUtils.wrapCheckedException(e);
        }
    }

    public String getToken() {
        return this.token;
    }

    public Boolean deletePage(ObjectRef pageRef) {
        Boolean result = this.modification.deletePage(pageRef);
        this.invalidateSnapshotCaches();
        return result;
    }

    List<ObjectRef> find(ObjectType type, Position position) {
        String path = "/pdf/find";
        return this.blockingClient.retrieve(HttpRequest.POST(path, new FindRequest(type, position, null)).contentType(MediaType.APPLICATION_JSON_TYPE).bearerAuth(this.token).header("X-Session-Id", this.sessionId), Argument.listOf(ObjectRef.class));
    }

    protected boolean delete(ObjectRef objectRef) {
        Boolean result = this.modification.delete(objectRef);
        this.invalidateSnapshotCaches();
        return Boolean.TRUE.equals(result);
    }

    public List<PageRef> getPages() {
        String path = "/pdf/page/find";
        return this.blockingClient.retrieve(HttpRequest.POST(path, null).contentType(MediaType.APPLICATION_JSON_TYPE).bearerAuth(this.token).header("X-Session-Id", this.sessionId), Argument.listOf(PageRef.class));
    }

    public ObjectRef getPage(int pageNumber) {
        if (pageNumber < 1) {
            throw new IllegalArgumentException("Page number must be >= 1 (1-based indexing)");
        }
        String path = "/pdf/page/find?pageNumber=" + pageNumber;
        List<ObjectRef> result = this.blockingClient.retrieve(HttpRequest.POST(path, null).contentType(MediaType.APPLICATION_JSON_TYPE).bearerAuth(this.token).header("X-Session-Id", this.sessionId), Argument.listOf(ObjectRef.class));
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    public byte[] getFileBytes() {
        String path = "/session/" + this.sessionId + "/pdf";
        return this.blockingClient.retrieve(HttpRequest.GET(path).bearerAuth(this.token), byte[].class);
    }

    protected Boolean move(ObjectRef objectRef, Position position) {
        Boolean result = this.modification.move(objectRef, position);
        this.invalidateSnapshotCaches();
        return result;
    }

    protected boolean addImage(Image image, Position position) {
        boolean result = this.modification.addImage(image, position);
        this.invalidateSnapshotCaches();
        return result;
    }

    protected Boolean addObject(PDFObject object) {
        Boolean result = this.modification.addObject(object);
        this.invalidateSnapshotCaches();
        return result;
    }

    private void invalidateSnapshotCaches() {
        this.snapshotCache.invalidate();
    }

    DocumentSnapshot getDocumentSnapshotCached(String types) {
        return this.snapshotCache.getDocumentSnapshotCached(types);
    }

    PageSnapshot getPageSnapshotCached(int pageNumber, String types) {
        return this.snapshotCache.getPageSnapshotCached(pageNumber, types);
    }

    public <T extends ObjectRef> TypedDocumentSnapshot<T> getTypedDocumentSnapshot(Class<T> elementClass, String types) {
        return this.snapshotCache.getTypedDocumentSnapshot(elementClass, types);
    }

    public <T extends ObjectRef> TypedPageSnapshot<T> getTypedPageSnapshot(int pageNumber, Class<T> elementClass, String types) {
        return this.snapshotCache.getTypedPageSnapshot(pageNumber, elementClass, types);
    }

    <T extends ObjectRef> List<T> getTypedElements(TypedPageSnapshot<T> page, Class<T> elementClass) {
        return this.selection.getTypedElements(page, elementClass);
    }

    private <T extends ObjectRef> List<T> flattenTypedDocument(TypedDocumentSnapshot<T> snapshot, Class<T> elementClass) {
        return this.selection.flattenTypedDocument(snapshot, elementClass);
    }

    private List<FormFieldRef> collectFormFieldRefsFromDocument() {
        return this.selection.collectFormFieldRefsFromDocument(this);
    }

    List<FormFieldRef> collectFormFieldRefsFromPage(int pageNumber) {
        return this.selection.collectFormFieldRefsFromPage(this, pageNumber);
    }

    private TextTypeObjectRef ensureTextType(TextTypeObjectRef ref, ObjectType desiredType) {
        if (ref == null) {
            return null;
        }
        if (desiredType == null || desiredType == ref.getType()) {
            return ref;
        }
        List<TextTypeObjectRef> children = ref.getChildren();
        ArrayList<TextTypeObjectRef> childCopies = children == null || children.isEmpty() ? null : new ArrayList<TextTypeObjectRef>(children);
        List<Double> lineSpacings = ref.getLineSpacings();
        ArrayList<Double> lineSpacingCopy = lineSpacings == null || lineSpacings.isEmpty() ? null : new ArrayList<Double>(lineSpacings);
        return new TextTypeObjectRef(ref.getInternalId(), ref.getPosition(), desiredType, ref.getObjectRefType(), ref.getFontName(), ref.getFontSize(), ref.getText(), lineSpacingCopy, ref.getColor(), ref.getStatus(), childCopies);
    }

    private List<TextTypeObjectRef> findParagraphs(Position position) {
        String path = "/pdf/find";
        return this.blockingClient.retrieve(HttpRequest.POST(path, new FindRequest(ObjectType.PARAGRAPH, position, null)).contentType(MediaType.APPLICATION_JSON_TYPE).bearerAuth(this.token).header("X-Session-Id", this.sessionId), Argument.listOf(TextTypeObjectRef.class));
    }

    private List<TextTypeObjectRef> findTextLines(Position position) {
        String path = "/pdf/find";
        return this.blockingClient.retrieve(HttpRequest.POST(path, new FindRequest(ObjectType.TEXT_LINE, position, null)).contentType(MediaType.APPLICATION_JSON_TYPE).bearerAuth(this.token).header("X-Session-Id", this.sessionId), Argument.listOf(TextTypeObjectRef.class));
    }

    private List<FormFieldRef> findFormFields(Position position) {
        String path = "/pdf/find";
        return this.blockingClient.retrieve(HttpRequest.POST(path, new FindRequest(ObjectType.FORM_FIELD, position, null)).contentType(MediaType.APPLICATION_JSON_TYPE).bearerAuth(this.token).header("X-Session-Id", this.sessionId), Argument.listOf(FormFieldRef.class));
    }

    private List<FormFieldRef> findFormFields() {
        return this.findFormFields(null);
    }

    List<ObjectRef> collectAllElements(DocumentSnapshot snapshot) {
        return this.selection.collectAllElements(snapshot);
    }

    List<ObjectRef> collectObjectsByType(DocumentSnapshot snapshot, Set<ObjectType> types) {
        return this.selection.collectObjectsByType(snapshot, types);
    }

    List<ObjectRef> collectObjectsByType(PageSnapshot snapshot, Set<ObjectType> types) {
        return this.selection.collectObjectsByType(snapshot, types);
    }

    boolean containsPoint(ObjectRef ref, double x, double y, double epsilon) {
        return this.selection.containsPoint(ref, x, y, epsilon);
    }

    boolean startsWithIgnoreCase(String value, String prefix) {
        return this.selection.startsWithIgnoreCase(value, prefix);
    }

    protected boolean modifyParagraph(ObjectRef ref, Paragraph newParagraph) {
        boolean success = this.modification.modifyParagraph(ref, newParagraph);
        this.invalidateSnapshotCaches();
        return success;
    }

    protected boolean modifyTextLine(ObjectRef ref, String newTextLine) {
        boolean success = this.modification.modifyTextLine(ref, newTextLine);
        this.invalidateSnapshotCaches();
        return success;
    }

    protected boolean modifyTextLine(ObjectRef ref, TextLine newTextLine) {
        boolean success = this.modification.modifyTextLine(ref, newTextLine);
        this.invalidateSnapshotCaches();
        return success;
    }

    protected boolean modifyParagraph(ObjectRef ref, String newText) {
        boolean success = this.modification.modifyParagraph(ref, newText);
        this.invalidateSnapshotCaches();
        return success;
    }

    protected boolean addParagaph(Paragraph newParagraph) {
        if (newParagraph.getPosition() == null) {
            throw new IllegalArgumentException("Paragraph getPosition is null");
        }
        if (newParagraph.getPosition().getPageNumber() == null) {
            throw new IllegalArgumentException("Paragraph getPosition page number is null");
        }
        if (newParagraph.getPosition().getPageNumber() < 0) {
            throw new IllegalArgumentException("Paragraph getPosition page number is less than 0");
        }
        return this.addObject(newParagraph);
    }

    public List<Font> findFonts(String fontName, int fontSize) {
        String path = "/font/find?fontName=" + fontName;
        List<String> fonts = this.blockingClient.retrieve(HttpRequest.GET(path).bearerAuth(this.token).header("X-Session-Id", this.sessionId), Argument.listOf(String.class));
        return fonts.stream().map(name -> new Font((String)name, fontSize)).collect(Collectors.toUnmodifiableList());
    }

    public String registerFont(File ttfFile) {
        String path = "/font/register";
        byte[] bytes = PDFDancer.readFile(ttfFile);
        MultipartBody body = MultipartBody.builder().addPart("ttfFile", ttfFile.getName(), new MediaType("font/ttf"), bytes).build();
        return this.blockingClient.retrieve(HttpRequest.POST(path, body).contentType(MediaType.MULTIPART_FORM_DATA_TYPE).bearerAuth(this.token).header("X-Session-Id", this.sessionId), String.class);
    }

    public ParagraphBuilder newParagraph() {
        return new ParagraphBuilder(this);
    }

    public ImageBuilder newImage() {
        return new ImageBuilder(this);
    }

    public void save(String filePath) {
        try {
            FileUtils.writeBytesToFile(this.getFileBytes(), filePath);
        }
        catch (IOException e) {
            throw ExceptionUtils.wrapCheckedException(e);
        }
    }

    public DocumentSnapshot getDocumentSnapshot() {
        return this.getDocumentSnapshotCached(null);
    }

    public DocumentSnapshot getDocumentSnapshot(String types) {
        return this.getDocumentSnapshotCached(types);
    }

    public PageSnapshot getPageSnapshot(int pageNumber) {
        if (pageNumber < 1) {
            throw new IllegalArgumentException("Page number must be >= 1 (1-based indexing)");
        }
        return this.getPageSnapshotCached(pageNumber, null);
    }

    public PageSnapshot getPageSnapshot(int pageNumber, String types) {
        if (pageNumber < 1) {
            throw new IllegalArgumentException("Page number must be >= 1 (1-based indexing)");
        }
        return this.getPageSnapshotCached(pageNumber, types);
    }

    protected boolean changeFormField(FormFieldRef objectRef, String value) {
        Boolean result = this.modification.changeFormField(objectRef, value);
        this.invalidateSnapshotCaches();
        return Boolean.TRUE.equals(result);
    }

    public List<TextParagraphReference> selectParagraphs() {
        TypedDocumentSnapshot<TextTypeObjectRef> snapshot = this.getTypedDocumentSnapshot(TextTypeObjectRef.class, TYPES_PARAGRAPH);
        List<TextTypeObjectRef> paragraphs = this.flattenTypedDocument(snapshot, TextTypeObjectRef.class);
        if (paragraphs.isEmpty() || paragraphs.stream().anyMatch(ref -> ref.getText() == null)) {
            paragraphs = this.findParagraphs(null);
        }
        return this.toTextObject(paragraphs);
    }

    public List<TextLineReference> selectTextLines() {
        TypedDocumentSnapshot<TextTypeObjectRef> snapshot = this.getTypedDocumentSnapshot(TextTypeObjectRef.class, TYPES_TEXT_LINE);
        List<TextTypeObjectRef> textLines = this.flattenTypedDocument(snapshot, TextTypeObjectRef.class);
        if (textLines.isEmpty() || textLines.stream().anyMatch(ref -> ref.getText() == null)) {
            textLines = this.findTextLines(null);
        }
        return this.toTextLineObject(textLines);
    }

    public List<PathReference> selectPaths() {
        DocumentSnapshot snapshot = this.getDocumentSnapshotCached(null);
        return this.toPathObject(this.collectObjectsByType(snapshot, Set.of(ObjectType.PATH)));
    }

    public PageClient page(int pageNumber) {
        if (pageNumber < 1) {
            throw new IllegalArgumentException("Page number must be >= 1 (1-based indexing)");
        }
        return new PageClient(this, pageNumber);
    }

    List<TextParagraphReference> toTextObject(List<TextTypeObjectRef> objectRefs) {
        return objectRefs.stream().map(ref -> this.ensureTextType((TextTypeObjectRef)ref, ObjectType.PARAGRAPH)).filter(Objects::nonNull).map(ref -> new TextParagraphReference((TextTypeObjectRef)ref, this)).collect(Collectors.toUnmodifiableList());
    }

    List<TextLineReference> toTextLineObject(List<TextTypeObjectRef> objectRefs) {
        return objectRefs.stream().map(ref -> this.ensureTextType((TextTypeObjectRef)ref, ObjectType.TEXT_LINE)).filter(Objects::nonNull).map(ref -> new TextLineReference(this, (TextTypeObjectRef)ref)).collect(Collectors.toUnmodifiableList());
    }

    List<PathReference> toPathObject(List<ObjectRef> objectRefs) {
        return objectRefs.stream().map(ref -> new PathReference((ObjectRef)ref, this)).collect(Collectors.toUnmodifiableList());
    }

    public List<ImageReference> selectImages() {
        DocumentSnapshot snapshot = this.getDocumentSnapshotCached(null);
        List<ObjectRef> images = this.collectObjectsByType(snapshot, Set.of(ObjectType.IMAGE));
        if (images.isEmpty()) {
            images = this.find(ObjectType.IMAGE, null);
        }
        return this.toImageObject(images);
    }

    List<ImageReference> toImageObject(List<ObjectRef> objectRefs) {
        return objectRefs.stream().map(ref -> new ImageReference(this, (ObjectRef)ref)).collect(Collectors.toUnmodifiableList());
    }

    List<FormXObjectReference> toFormXObject(List<ObjectRef> objectRefs) {
        return objectRefs.stream().map(ref -> new FormXObjectReference(this, (ObjectRef)ref)).collect(Collectors.toUnmodifiableList());
    }

    public List<FormXObjectReference> selectForms() {
        boolean needsFallback;
        DocumentSnapshot snapshot = this.getDocumentSnapshotCached(null);
        List<ObjectRef> forms = this.collectObjectsByType(snapshot, Set.of(ObjectType.FORM_X_OBJECT));
        boolean bl = needsFallback = forms.isEmpty() || forms.stream().anyMatch(Objects::isNull) || forms.stream().allMatch(ref -> ref.getPosition() == null || ref.getPosition().getX() == null && ref.getPosition().getY() == null);
        if (needsFallback) {
            forms = this.find(ObjectType.FORM_X_OBJECT, null);
        }
        return this.toFormXObject(forms);
    }

    public List<FormFieldReference> selectFormFields() {
        List<FormFieldRef> formFields = this.collectFormFieldRefsFromDocument();
        return this.toFormFieldObject(formFields);
    }

    List<FormFieldReference> toFormFieldObject(List<FormFieldRef> formFields) {
        return formFields.stream().map(ref -> new FormFieldReference(this, (FormFieldRef)ref)).collect(Collectors.toUnmodifiableList());
    }

    public List<FormFieldReference> selectFormFieldsByName(String elementName) {
        List<FormFieldRef> base = this.collectFormFieldRefsFromDocument();
        return this.toFormFieldObject(base.stream().filter(ref -> Objects.equals(ref.getName(), elementName)).collect(Collectors.toUnmodifiableList()));
    }

    public Optional<FormFieldReference> selectFormFieldByName(String elementName) {
        List<FormFieldReference> formFields = this.selectFormFieldsByName(elementName);
        return formFields.isEmpty() ? Optional.empty() : Optional.of(formFields.get(0));
    }

    public List<ObjectRef> selectElements() {
        List<ObjectRef> fallback = this.find(null, null);
        DocumentSnapshot snapshot = this.getDocumentSnapshotCached(null);
        List<ObjectRef> elements = this.collectAllElements(snapshot);
        if (fallback.size() > elements.size()) {
            return fallback;
        }
        return elements;
    }

    public PageRef addPage() {
        return this.addPage(null);
    }

    public PageRef addPage(AddPageRequest request) {
        PageRef result = this.modification.addPage(request);
        this.invalidateSnapshotCaches();
        return result;
    }

    public PageBuilder newPage() {
        return new PageBuilder(this);
    }

    @Deprecated
    public PageBuilder page() {
        return this.newPage();
    }

    public boolean movePage(int fromPage, int toPage) {
        if (fromPage < 1) {
            throw new IllegalArgumentException("fromPage must be >= 1 (1-based indexing)");
        }
        if (toPage < 1) {
            throw new IllegalArgumentException("toPage must be >= 1 (1-based indexing)");
        }
        Boolean result = this.modification.movePage(fromPage, toPage);
        this.invalidateSnapshotCaches();
        return Boolean.TRUE.equals(result);
    }

    public RedactResponse redact(List<? extends BaseReference> objects) {
        return this.redact(objects, "[REDACTED]", Color.BLACK);
    }

    public RedactResponse redact(List<? extends BaseReference> objects, String replacement) {
        return this.redact(objects, replacement, Color.BLACK);
    }

    public RedactResponse redact(List<? extends BaseReference> objects, Color placeholderColor) {
        return this.redact(objects, "[REDACTED]", placeholderColor);
    }

    public RedactResponse redact(List<? extends BaseReference> objects, String replacement, Color placeholderColor) {
        if (objects == null || objects.isEmpty()) {
            throw new IllegalArgumentException("At least one object is required");
        }
        RedactRequest.Builder builder = RedactRequest.builder().defaultReplacement(replacement).placeholderColor(placeholderColor);
        for (BaseReference baseReference : objects) {
            builder.addTargetById(baseReference.getInternalId());
        }
        return this.redact(builder.build());
    }

    RedactResponse redact(RedactRequest request) {
        RedactResponse result = this.modification.redact(request);
        this.invalidateSnapshotCaches();
        return result;
    }

    protected boolean transformImage(ImageTransformRequest request) {
        boolean result = this.modification.transformImage(request);
        this.invalidateSnapshotCaches();
        return result;
    }

    public boolean applyReplacements(TemplateReplaceRequest request) {
        boolean result = this.modification.replaceTemplates(request);
        this.invalidateSnapshotCaches();
        return result;
    }

    public PdfDancerHttpClient getHttpClient() {
        return this.httpClient;
    }

    public static class PageClient
    extends PageClientImpl {
        PageClient(PDFDancer root, int pageNumber) {
            super(root, pageNumber);
        }
    }
}

