/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.common.model.path;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.pdfdancer.common.model.ObjectType;
import com.pdfdancer.common.model.PDFObject;
import com.pdfdancer.common.model.Position;
import com.pdfdancer.common.model.path.PathSegment;
import java.util.ArrayList;
import java.util.List;

public class Path
extends PDFObject {
    private List<PathSegment> pathSegments = new ArrayList<PathSegment>();
    private Boolean evenOddFill;

    @Override
    public Position getPosition() {
        double minX = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        for (PathSegment pathSegment : this.pathSegments) {
            Position position = pathSegment.getPosition();
            if (position.getX() < minX) {
                minX = position.getX();
            }
            if (!(position.getY() > maxY)) continue;
            maxY = position.getY();
        }
        return new Position(minX, maxY);
    }

    @Override
    @JsonIgnore
    public void setPosition(Position position) {
        throw new UnsupportedOperationException();
    }

    public List<PathSegment> getPathSegments() {
        return this.pathSegments;
    }

    public void setPathSegments(List<PathSegment> pathSegments) {
        this.pathSegments = pathSegments != null ? pathSegments : new ArrayList();
    }

    public void addPathSegment(PathSegment pathSegment) {
        this.pathSegments.add(pathSegment);
    }

    public Boolean getEvenOddFill() {
        return this.evenOddFill;
    }

    public void setEvenOddFill(Boolean evenOddFill) {
        this.evenOddFill = evenOddFill;
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.PATH;
    }
}

