/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.common.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.pdfdancer.common.model.ReflowPreset;
import com.pdfdancer.common.request.TemplateReplacement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class TemplateReplaceRequest {
    @JsonProperty(value="replacements")
    private final List<TemplateReplacement> replacements;
    @JsonProperty(value="pageIndex")
    private final Integer pageIndex;
    @JsonProperty(value="reflowPreset")
    private final ReflowPreset reflowPreset;

    @JsonCreator
    public TemplateReplaceRequest(@JsonProperty(value="replacements") List<TemplateReplacement> replacements, @JsonProperty(value="pageIndex") Integer pageIndex, @JsonProperty(value="reflowPreset") ReflowPreset reflowPreset) {
        this.replacements = replacements != null ? List.copyOf(replacements) : List.of();
        this.pageIndex = pageIndex;
        this.reflowPreset = reflowPreset;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<TemplateReplacement> replacements() {
        return this.replacements;
    }

    public Integer pageIndex() {
        return this.pageIndex;
    }

    public ReflowPreset reflowPreset() {
        return this.reflowPreset;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TemplateReplaceRequest that = (TemplateReplaceRequest)obj;
        return Objects.equals(this.replacements, that.replacements) && Objects.equals(this.pageIndex, that.pageIndex) && Objects.equals((Object)this.reflowPreset, (Object)that.reflowPreset);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.replacements, this.pageIndex, this.reflowPreset});
    }

    public String toString() {
        return "TemplateReplaceRequest[replacements=" + String.valueOf(this.replacements) + ", pageIndex=" + this.pageIndex + ", reflowPreset=" + String.valueOf((Object)this.reflowPreset) + "]";
    }

    public static class Builder {
        private final List<TemplateReplacement> replacements = new ArrayList<TemplateReplacement>();
        private Integer pageIndex = null;
        private ReflowPreset reflowPreset = null;

        public Builder pageIndex(Integer pageIndex) {
            this.pageIndex = pageIndex;
            return this;
        }

        public Builder reflowPreset(ReflowPreset reflowPreset) {
            this.reflowPreset = reflowPreset;
            return this;
        }

        public Builder addReplacement(TemplateReplacement replacement) {
            this.replacements.add(replacement);
            return this;
        }

        public Builder replace(String placeholder, String text) {
            this.replacements.add(TemplateReplacement.of(placeholder, text));
            return this;
        }

        public TemplateReplaceRequest build() {
            return new TemplateReplaceRequest(this.replacements, this.pageIndex, this.reflowPreset);
        }
    }
}

