/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.client.rest;

import com.pdfdancer.client.rest.BaseReference;
import com.pdfdancer.client.rest.PDFDancer;
import com.pdfdancer.common.model.Image;
import com.pdfdancer.common.model.ObjectRef;
import com.pdfdancer.common.model.Size;
import com.pdfdancer.common.request.ImageTransformRequest;
import java.io.File;
import java.io.IOException;

public class ImageReference
extends BaseReference {
    public ImageReference(PDFDancer client, ObjectRef objectRef) {
        super(client, objectRef);
    }

    public Double getWidth() {
        if (this.objectRef.getPosition() == null || this.objectRef.getPosition().getBoundingRect() == null) {
            return null;
        }
        return this.objectRef.getPosition().getBoundingRect().getWidth();
    }

    public Double getHeight() {
        if (this.objectRef.getPosition() == null || this.objectRef.getPosition().getBoundingRect() == null) {
            return null;
        }
        return this.objectRef.getPosition().getBoundingRect().getHeight();
    }

    public Double getAspectRatio() {
        Double width = this.getWidth();
        Double height = this.getHeight();
        if (width == null || height == null || height == 0.0) {
            return null;
        }
        return width / height;
    }

    public boolean replace(File imageFile) throws IOException {
        Image newImage = Image.fromFile(imageFile);
        return this.replace(newImage);
    }

    public boolean replace(Image newImage) {
        ImageTransformRequest request = ImageTransformRequest.builder(this.objectRef).replace(newImage).build();
        return this.client.transformImage(request);
    }

    public boolean scale(double scaleFactor) {
        ImageTransformRequest request = ImageTransformRequest.builder(this.objectRef).scale(scaleFactor).build();
        return this.client.transformImage(request);
    }

    public boolean scaleTo(Size targetSize) {
        return this.scaleTo(targetSize, true);
    }

    public boolean scaleTo(Size targetSize, boolean preserveAspectRatio) {
        ImageTransformRequest request = ImageTransformRequest.builder(this.objectRef).scaleTo(targetSize, preserveAspectRatio).build();
        return this.client.transformImage(request);
    }

    public boolean scaleTo(double width, double height) {
        return this.scaleTo(new Size(width, height), false);
    }

    public boolean scaleTo(double width, double height, boolean preserveAspectRatio) {
        return this.scaleTo(new Size(width, height), preserveAspectRatio);
    }

    public boolean rotate(double angle) {
        ImageTransformRequest request = ImageTransformRequest.builder(this.objectRef).rotate(angle).build();
        return this.client.transformImage(request);
    }

    public boolean crop(int left, int top, int right, int bottom) {
        ImageTransformRequest request = ImageTransformRequest.builder(this.objectRef).crop(left, top, right, bottom).build();
        return this.client.transformImage(request);
    }

    public boolean opacity(double opacity) {
        ImageTransformRequest request = ImageTransformRequest.builder(this.objectRef).opacity(opacity).build();
        return this.client.transformImage(request);
    }

    public boolean flip(ImageTransformRequest.FlipDirection direction) {
        ImageTransformRequest request = ImageTransformRequest.builder(this.objectRef).flip(direction).build();
        return this.client.transformImage(request);
    }

    public boolean flipHorizontal() {
        return this.flip(ImageTransformRequest.FlipDirection.HORIZONTAL);
    }

    public boolean flipVertical() {
        return this.flip(ImageTransformRequest.FlipDirection.VERTICAL);
    }
}

