/*
 * Decompiled with CFR 0.152.
 */
package com.pdfdancer.common.model.text;

import com.pdfdancer.common.model.Font;
import com.pdfdancer.common.model.ObjectType;
import com.pdfdancer.common.model.PDFObject;
import com.pdfdancer.common.model.Position;
import com.pdfdancer.common.model.TextStatus;
import com.pdfdancer.common.model.TextTypeObjectRef;
import com.pdfdancer.common.model.text.TextLine;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Paragraph
extends PDFObject {
    private final List<TextLine> lines = new ArrayList<TextLine>();
    private List<Double> lineSpacings;
    private Font font;
    private String text;

    public Paragraph() {
    }

    public Paragraph(String id, List<TextLine> lines, Position position) {
        super(id, position);
        this.lines.addAll(lines);
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.PARAGRAPH;
    }

    public List<TextLine> getLines() {
        return this.lines;
    }

    public void setLines(List<TextLine> lines) {
        this.lines.clear();
        this.lines.addAll(lines);
    }

    public List<Double> getLineSpacings() {
        return this.lineSpacings;
    }

    public void setLineSpacings(List<Double> lineSpacings) {
        this.lineSpacings = lineSpacings;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void clearLines() {
        this.lines.clear();
    }

    public void addLine(TextLine textLine) {
        this.lines.add(textLine);
    }

    @Override
    public TextTypeObjectRef toObjectRef() {
        return new TextTypeObjectRef(this.getId(), this.getPosition(), this.getObjectType(), this.getObjectType(), this.font != null ? this.font.getName() : null, this.font != null ? Double.valueOf(this.font.getSize()) : null, this.getText(), this.lineSpacings, this.lines.stream().filter(l -> l.getColor() != null).findFirst().map(TextLine::getColor).orElse(null), TextStatus.fromParagraph(this), this.lines.stream().map(TextLine::toObjectRef).collect(Collectors.toUnmodifiableList()));
    }

    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        return this.lines.stream().map(TextLine::getText).collect(Collectors.joining("\n"));
    }

    public void setText(String text) {
        this.text = text;
    }
}

