/*
 * Decompiled with CFR 0.152.
 */
package com.peertopark.java.validators;

import es.blackleg.java.utilities.Objects;
import org.apache.commons.validator.routines.DateValidator;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.commons.validator.routines.RegexValidator;

public class Validator {
    public static RegexValidator getRegexValidator(String pattern) {
        return new RegexValidator(pattern, true);
    }

    public static RegexValidator getRegexValidatorNotCaseSensitive(String pattern) {
        return new RegexValidator(pattern, false);
    }

    public static boolean validateStringWithPattern(String string, String pattern) {
        return Validator.getRegexValidator(pattern).isValid(string);
    }

    public static boolean stringMaxLength(String string, int length) {
        return Objects.nonNull((Object)string) && string.length() <= length;
    }

    public static boolean stringMinLength(String string, int length) {
        return Objects.nonNull((Object)string) && string.length() >= length;
    }

    public static boolean validateDate(String date, String format) {
        return Validator.getDateValidator().isValid(date, format);
    }

    public static DateValidator getDateValidator() {
        return new DateValidator();
    }

    public static EmailValidator getEmailValidator() {
        return EmailValidator.getInstance();
    }

    public static boolean validateEmail(String email) {
        return Validator.getEmailValidator().isValid(email);
    }

    public static boolean stringLength(String string, int minLength, int maxLength) {
        return Validator.stringMinLength(string, minLength) && Validator.stringMaxLength(string, maxLength);
    }
}

