/*
 * Decompiled with CFR 0.152.
 */
package com.peertopark.java.validators;

import com.peertopark.java.validators.Validator;

public class PasswordValidator
extends Validator {
    private static int passwordMinLength = 8;
    private static int passwordMaxLength = 15;
    private static final String PASSWORD_BASE_REGEX = "^%s{%d,%d}$";
    private static String passwordRegex = "[a-z0-9]";

    public static boolean validate(String password) {
        return PasswordValidator.validateStringWithPattern(password, PasswordValidator.makePasswordRegex());
    }

    private static String makePasswordRegex() {
        return String.format(PASSWORD_BASE_REGEX, passwordRegex, passwordMinLength, passwordMaxLength);
    }

    public static int getPasswordMinLength() {
        return passwordMinLength;
    }

    public static void setPasswordMinLength(int passwordMinLength) {
        PasswordValidator.passwordMinLength = passwordMinLength;
    }

    public static int getPasswordMaxLength() {
        return passwordMaxLength;
    }

    public static void setPasswordMaxLength(int passwordMaxLength) {
        PasswordValidator.passwordMaxLength = passwordMaxLength;
    }

    public static String getPasswordRegex() {
        return passwordRegex;
    }

    public static void setPasswordRegex(String passwordRegex) {
        PasswordValidator.passwordRegex = passwordRegex;
    }
}

