/*
 * Decompiled with CFR 0.152.
 */
package com.pervasivecode.utils.time.testing;

import com.pervasivecode.utils.time.api.TimeSource;
import java.time.Duration;
import java.time.Instant;

public class FakeTimeSource
implements TimeSource {
    private static final Instant START_INSTANT = Instant.ofEpochMilli(987654321L);
    private static final Duration TIME_TO_ADD_AFTER_EVERY_NOW_CALL = Duration.ofMillis(137L);
    private boolean autoAdvance;
    private Instant currentTime = START_INSTANT;

    public FakeTimeSource() {
        this(true);
    }

    public FakeTimeSource(boolean autoAdvance) {
        this.autoAdvance = autoAdvance;
    }

    @Override
    public Instant now() {
        Instant returnValue = this.currentTime;
        if (this.autoAdvance) {
            this.advance();
        }
        return returnValue;
    }

    public void advance() {
        this.advance(TIME_TO_ADD_AFTER_EVERY_NOW_CALL);
    }

    public void advance(Duration timeToAdd) {
        this.currentTime = this.currentTime.plus(timeToAdd);
    }

    public Duration elapsedSoFar() {
        return Duration.between(START_INSTANT, this.currentTime);
    }
}

