/*
 * Decompiled with CFR 0.152.
 */
package com.pervasivecode.utils.time;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.pervasivecode.utils.time.$AutoValue_DurationFormat;
import com.pervasivecode.utils.time.DurationRemainderHandling;
import com.pervasivecode.utils.time.UnitSuffixProvider;
import java.text.NumberFormat;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class DurationFormat {
    private static final Comparator<ChronoUnit> DURATION_COMPARATOR = (unit, otherUnit) -> unit.compareTo(otherUnit);
    private static final ImmutableSortedSet<ChronoUnit> CHRONO_UNIT_VALUES = ImmutableSortedSet.copyOf(DURATION_COMPARATOR, (Collection)Lists.newArrayList((Object[])ChronoUnit.values()));

    protected DurationFormat() {
    }

    private static ImmutableSortedSet<ChronoUnit> range(ChronoUnit from, ChronoUnit to) {
        return CHRONO_UNIT_VALUES.headSet((Object)to, true).tailSet((Object)from, true);
    }

    public abstract UnitSuffixProvider unitSuffixProvider();

    public abstract String partDelimiter();

    public abstract NumberFormat numberFormat();

    public abstract ChronoUnit largestUnit();

    public abstract ChronoUnit smallestUnit();

    public abstract ChronoUnit unitForZeroDuration();

    public abstract Set<ChronoUnit> suppressedUnits();

    public abstract Integer numFractionalDigits();

    public abstract DurationRemainderHandling remainderHandling();

    public List<ChronoUnit> units() {
        ImmutableList.Builder unitsBuilder = ImmutableList.builder();
        ImmutableSortedSet<ChronoUnit> rawRange = DurationFormat.range(this.smallestUnit(), this.largestUnit());
        for (ChronoUnit unit : rawRange) {
            if (this.suppressedUnits().contains(unit)) continue;
            unitsBuilder.add((Object)unit);
        }
        return unitsBuilder.build();
    }

    public static Builder builder() {
        return new $AutoValue_DurationFormat.Builder().setSuppressedUnits((Set<ChronoUnit>)ImmutableSet.of((Object)ChronoUnit.HALF_DAYS)).setRemainderHandling(DurationRemainderHandling.TRUNCATE);
    }

    public static Builder builder(DurationFormat format) {
        return DurationFormat.builder().setUnitSuffixProvider(format.unitSuffixProvider()).setPartDelimiter(format.partDelimiter()).setNumberFormat(format.numberFormat()).setLargestUnit(format.largestUnit()).setSmallestUnit(format.smallestUnit()).setUnitForZeroDuration(format.unitForZeroDuration()).setNumFractionalDigits(format.numFractionalDigits()).setSuppressedUnits(format.suppressedUnits()).setRemainderHandling(format.remainderHandling());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        protected Builder() {
        }

        public abstract Builder setUnitSuffixProvider(UnitSuffixProvider var1);

        public abstract Builder setPartDelimiter(String var1);

        public abstract Builder setNumberFormat(NumberFormat var1);

        public abstract Builder setLargestUnit(ChronoUnit var1);

        public abstract Builder setSmallestUnit(ChronoUnit var1);

        public abstract Builder setUnitForZeroDuration(ChronoUnit var1);

        public abstract Builder setSuppressedUnits(Set<ChronoUnit> var1);

        public abstract Builder setNumFractionalDigits(Integer var1);

        public abstract Builder setRemainderHandling(DurationRemainderHandling var1);

        protected abstract DurationFormat buildInternal();

        public DurationFormat build() {
            DurationFormat format = this.buildInternal();
            Builder.requireSmallestNotLargerThanLargest(format);
            Preconditions.checkState((!format.units().isEmpty() ? 1 : 0) != 0, (String)"suppressedUnits (%s) leaves no units available for formatting", format.suppressedUnits());
            Builder.requireLabelsForUsableUnits(format);
            Preconditions.checkState((boolean)format.units().contains(format.unitForZeroDuration()), (String)"The unitForZeroDuration '%s' is not in the list of units: %s.", (Object)format.unitForZeroDuration(), format.units());
            Preconditions.checkState((format.numFractionalDigits() >= 0 ? 1 : 0) != 0, (String)"The number of fractional digits must be nonnegative. Got: %s", (Object)format.numFractionalDigits());
            return format;
        }

        private static void requireLabelsForUsableUnits(DurationFormat format) {
            for (int i = -2; i <= 2; ++i) {
                for (ChronoUnit unit : format.units()) {
                    String suffix = format.unitSuffixProvider().suffixFor(unit, i);
                    Preconditions.checkState((suffix != null ? 1 : 0) != 0, (String)"Missing unit suffix for quantity %s of unit %s", (int)i, (Object)unit);
                }
            }
        }

        private static void requireSmallestNotLargerThanLargest(DurationFormat format) {
            ChronoUnit smallestUnit = format.smallestUnit();
            ChronoUnit largestUnit = format.largestUnit();
            Preconditions.checkState((smallestUnit.getDuration().compareTo(largestUnit.getDuration()) <= 0 ? 1 : 0) != 0, (String)"Invalid range of units: smallest is %s, largest is %s", (Object)smallestUnit.name(), (Object)largestUnit.name());
        }
    }
}

