/*
 * Decompiled with CFR 0.152.
 */
package com.pervasivecode.utils.time;

import com.google.common.collect.ImmutableMap;
import com.pervasivecode.utils.time.DurationFormat;
import com.pervasivecode.utils.time.UnitSuffixProvider;
import com.pervasivecode.utils.time.UnitSuffixProviders;
import java.text.NumberFormat;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.Map;

public class DurationFormats {
    private DurationFormats() {
    }

    public static DurationFormat getUsDefaultInstance() {
        return DurationFormat.builder().setUnitSuffixProvider(DurationFormats.usShortSuffixProvider()).setPartDelimiter(" ").setNumberFormat(NumberFormat.getInstance(Locale.US)).setLargestUnit(ChronoUnit.YEARS).setSmallestUnit(ChronoUnit.NANOS).setUnitForZeroDuration(ChronoUnit.SECONDS).setNumFractionalDigits(0).build();
    }

    public static UnitSuffixProvider usShortSuffixProvider() {
        ImmutableMap unitSuffixes = ImmutableMap.builder().put((Object)ChronoUnit.NANOS, (Object)"ns").put((Object)ChronoUnit.MICROS, (Object)"\u00b5s").put((Object)ChronoUnit.MILLIS, (Object)"ms").put((Object)ChronoUnit.SECONDS, (Object)"s").put((Object)ChronoUnit.MINUTES, (Object)"m").put((Object)ChronoUnit.HOURS, (Object)"h").put((Object)ChronoUnit.DAYS, (Object)"d").put((Object)ChronoUnit.WEEKS, (Object)"w").put((Object)ChronoUnit.MONTHS, (Object)"mo").put((Object)ChronoUnit.YEARS, (Object)"y").build();
        UnitSuffixProvider suffixProvider = UnitSuffixProviders.fixedSuffixPerUnit((Map<ChronoUnit, String>)unitSuffixes);
        return suffixProvider;
    }
}

