/*
 * Decompiled with CFR 0.152.
 */
package com.pervasivecode.utils.time;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.pervasivecode.utils.time.DurationFormat;
import com.pervasivecode.utils.time.DurationRemainderHandling;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Objects;

public final class DurationFormatter {
    private static final BigInteger NANOS_PER_SECOND = BigInteger.valueOf(1000000000L);
    private static final BigInteger INT_MAX_AS_BIG = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger INT_MIN_AS_BIG = BigInteger.valueOf(Integer.MIN_VALUE);
    private final DurationFormat format;
    private final transient Joiner partJoiner;

    public DurationFormatter(DurationFormat format) {
        this.format = Objects.requireNonNull(format);
        this.partJoiner = Joiner.on((String)format.partDelimiter());
    }

    private static BigInteger wholeDurationAsNanos(Duration duration) {
        BigInteger secondsPart = BigInteger.valueOf(duration.getSeconds());
        BigInteger nanosPart = BigInteger.valueOf(duration.getNano());
        return secondsPart.multiply(NANOS_PER_SECOND).add(nanosPart);
    }

    public String format(Duration duration) {
        if (duration.isZero()) {
            return this.formatZero();
        }
        NumberFormat nf = (NumberFormat)this.format.numberFormat().clone();
        nf.setRoundingMode(RoundingMode.UNNECESSARY);
        nf.setMinimumFractionDigits(0);
        nf.setMaximumFractionDigits(0);
        ImmutableList unitsInDescOrder = ImmutableList.copyOf(this.format.units()).reverse();
        ArrayList<String> parts = new ArrayList<String>();
        BigInteger bigNanosRemaining = DurationFormatter.wholeDurationAsNanos(duration);
        for (int unitIndex = 0; unitIndex < unitsInDescOrder.size(); ++unitIndex) {
            String suffix;
            ChronoUnit currentUnit = (ChronoUnit)unitsInDescOrder.get(unitIndex);
            BigInteger currentUnitInNanos = DurationFormatter.wholeDurationAsNanos(currentUnit.getDuration());
            BigInteger bigNanosRemainingBeforeIntDivision = bigNanosRemaining;
            BigInteger[] quotientAndRemainder = bigNanosRemaining.divideAndRemainder(currentUnitInNanos);
            BigInteger partValue = quotientAndRemainder[0];
            bigNanosRemaining = quotientAndRemainder[1];
            if (parts.isEmpty()) {
                if (partValue.equals(BigInteger.ZERO) && currentUnit != this.format.smallestUnit()) continue;
                bigNanosRemaining = bigNanosRemaining.abs();
            }
            StringBuilder sb = new StringBuilder();
            if (currentUnit == this.format.smallestUnit() && (this.format.numFractionalDigits() > 0 || this.format.remainderHandling() == DurationRemainderHandling.ROUND_HALF_EVEN)) {
                BigDecimal partValueWithFraction = new BigDecimal(bigNanosRemainingBeforeIntDivision).divide(new BigDecimal(currentUnitInNanos));
                BigDecimal roundedPartValue = partValueWithFraction.setScale((int)this.format.numFractionalDigits(), RoundingMode.HALF_EVEN);
                nf.setRoundingMode(RoundingMode.HALF_EVEN);
                nf.setMaximumFractionDigits(this.format.numFractionalDigits());
                String fractionPart = nf.format(partValueWithFraction);
                if (fractionPart.equals("0")) {
                    if (!parts.isEmpty()) break;
                    return this.formatZero();
                }
                sb.append(fractionPart);
                suffix = this.format.unitSuffixProvider().suffixFor(currentUnit, roundedPartValue);
            } else {
                String wholeNumberPart = nf.format(partValue);
                sb.append(wholeNumberPart);
                suffix = this.suffixFor(currentUnit, partValue);
            }
            Objects.requireNonNull(suffix);
            sb.append(suffix);
            parts.add(sb.toString());
            if (bigNanosRemaining.equals(BigInteger.ZERO)) break;
        }
        return this.partJoiner.join(parts);
    }

    private String suffixFor(ChronoUnit unit, BigInteger partValue) {
        if (partValue.compareTo(INT_MAX_AS_BIG) > 0 || partValue.compareTo(INT_MIN_AS_BIG) < 0) {
            return this.format.unitSuffixProvider().suffixFor(unit, new BigDecimal(partValue));
        }
        return this.format.unitSuffixProvider().suffixFor(unit, partValue.intValue());
    }

    private String formatZero() {
        String zeroSuffix = this.format.unitSuffixProvider().suffixFor(this.format.unitForZeroDuration(), BigDecimal.ZERO);
        NumberFormat nf = (NumberFormat)this.format.numberFormat().clone();
        nf.setMinimumFractionDigits(0);
        nf.setMaximumFractionDigits(0);
        return nf.format(0L) + zeroSuffix;
    }

    public int hashCode() {
        return Objects.hash(this.format);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DurationFormatter)) {
            return false;
        }
        DurationFormatter otherFormatter = (DurationFormatter)other;
        return Objects.equals(otherFormatter.format, this.format);
    }
}

