/*
 * Decompiled with CFR 0.152.
 */
package com.pervasivecode.utils.time;

import com.google.common.base.Preconditions;
import com.pervasivecode.utils.time.PeriodicRunner;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class SimplePeriodicRunner
implements PeriodicRunner {
    private final Duration progressUpdateInterval;
    private final ScheduledExecutorService executor;
    private ScheduledFuture<?> scheduled = null;
    private Runnable task;

    SimplePeriodicRunner(ScheduledExecutorService executor, Duration period) {
        this.executor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executor);
        this.progressUpdateInterval = (Duration)Preconditions.checkNotNull((Object)period);
    }

    @Override
    public void setPeriodicTask(Runnable task) {
        Preconditions.checkState((this.scheduled == null ? 1 : 0) != 0, (Object)"A task is already scheduled in this runner. Call stop() before setting a different scheduled task, or create a new SimplePeriodicRunner instance to handle an additional scheduled task.");
        this.task = (Runnable)Preconditions.checkNotNull((Object)task);
    }

    @Override
    public void start() {
        Preconditions.checkState((this.task != null ? 1 : 0) != 0, (Object)"No periodic task has been set.");
        Preconditions.checkState((this.scheduled == null ? 1 : 0) != 0, (Object)"The task has already been started.");
        long periodInMillis = this.progressUpdateInterval.toMillis();
        this.scheduled = this.executor.scheduleAtFixedRate(this.task, periodInMillis, periodInMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        Preconditions.checkState((this.scheduled != null ? 1 : 0) != 0, (Object)"The periodic task has not been started yet, or has been stopped.");
        this.scheduled.cancel(false);
        this.scheduled = null;
    }

    public int hashCode() {
        return Objects.hash(this.progressUpdateInterval, this.executor, this.scheduled, this.task);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SimplePeriodicRunner)) {
            return false;
        }
        SimplePeriodicRunner otherRunner = (SimplePeriodicRunner)other;
        return Objects.equals(otherRunner.progressUpdateInterval, this.progressUpdateInterval) && Objects.equals(otherRunner.executor, this.executor) && Objects.equals(otherRunner.scheduled, this.scheduled) && Objects.equals(otherRunner.task, this.task);
    }
}

