/*
 * Decompiled with CFR 0.152.
 */
package com.pervasivecode.utils.time;

import com.google.common.annotations.VisibleForTesting;
import com.pervasivecode.utils.time.SimplePeriodicRunner;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class SimplePeriodicRunnerFactory {
    private final ScheduledExecutorService executor;

    @VisibleForTesting
    static ScheduledThreadPoolExecutor createExecutorService() {
        ScheduledThreadPoolExecutor stpe = new ScheduledThreadPoolExecutor(1, new ThreadPoolExecutor.AbortPolicy());
        stpe.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        stpe.setKeepAliveTime(1L, TimeUnit.SECONDS);
        stpe.setRemoveOnCancelPolicy(true);
        return stpe;
    }

    public SimplePeriodicRunnerFactory() {
        this.executor = SimplePeriodicRunnerFactory.createExecutorService();
    }

    @VisibleForTesting
    SimplePeriodicRunnerFactory(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    public SimplePeriodicRunner getRunnerForInterval(Duration executionInterval) {
        return new SimplePeriodicRunner(this.executor, executionInterval);
    }

    public void shutdownGracefully(long timeout, TimeUnit unit) throws InterruptedException {
        this.executor.shutdown();
        this.executor.awaitTermination(timeout, unit);
        if (!this.executor.isTerminated()) {
            this.shutdownNow();
        }
    }

    public void shutdownNow() {
        this.executor.shutdownNow();
    }

    public int hashCode() {
        return Objects.hash(this.executor);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SimplePeriodicRunnerFactory)) {
            return false;
        }
        SimplePeriodicRunnerFactory otherFactory = (SimplePeriodicRunnerFactory)other;
        return Objects.equals(otherFactory.executor, this.executor);
    }
}

