/*
 * Decompiled with CFR 0.152.
 */
package com.pervasivecode.utils.time;

import com.pervasivecode.utils.time.UnitSuffixProvider;
import java.math.BigDecimal;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Objects;

public class UnitSuffixProviders {
    private static final BigDecimal BIG_NEGATIVE_ONE = BigDecimal.ONE.negate();

    private UnitSuffixProviders() {
    }

    public static UnitSuffixProvider fixedSuffixPerUnit(final Map<ChronoUnit, String> unitSuffixes) {
        Objects.requireNonNull(unitSuffixes);
        return new UnitSuffixProvider(){

            @Override
            public String suffixFor(ChronoUnit unit, BigDecimal magnitude) {
                return (String)unitSuffixes.get(unit);
            }

            @Override
            public String suffixFor(ChronoUnit unit, int magnitude) {
                return (String)unitSuffixes.get(unit);
            }
        };
    }

    public static UnitSuffixProvider singularAndPlural(Map<ChronoUnit, String> singularUnitSuffixes, Map<ChronoUnit, String> pluralUnitSuffixes) {
        return UnitSuffixProviders.singularAndPlural(singularUnitSuffixes, pluralUnitSuffixes, false);
    }

    public static UnitSuffixProvider singularAndPlural(final Map<ChronoUnit, String> singularUnitSuffixes, final Map<ChronoUnit, String> pluralUnitSuffixes, final boolean negativeOneIsSingular) {
        Objects.requireNonNull(singularUnitSuffixes);
        Objects.requireNonNull(pluralUnitSuffixes);
        return new UnitSuffixProvider(){

            @Override
            public String suffixFor(ChronoUnit unit, BigDecimal magnitude) {
                boolean singular = magnitude.compareTo(BigDecimal.ONE) == 0 || negativeOneIsSingular && magnitude.compareTo(BIG_NEGATIVE_ONE) == 0;
                return this.suffixFor(unit, singular);
            }

            @Override
            public String suffixFor(ChronoUnit unit, int magnitude) {
                boolean singular = magnitude == 1 || negativeOneIsSingular && magnitude == -1;
                return this.suffixFor(unit, singular);
            }

            private String suffixFor(ChronoUnit unit, boolean singular) {
                return (String)(singular ? singularUnitSuffixes : pluralUnitSuffixes).get(unit);
            }
        };
    }
}

