/*
 * Decompiled with CFR 0.152.
 */
package com.phaxio.repositories;

import com.phaxio.resources.PhoneNumber;
import com.phaxio.restclient.RestClient;
import com.phaxio.restclient.entities.RestRequest;
import com.phaxio.services.Requests;
import java.util.HashMap;
import java.util.Map;

public class PhoneNumberRepository {
    private Requests client;

    public PhoneNumberRepository(Requests client) {
        this.client = client;
    }

    public PhoneNumber create(String countryCode, String areaCode) {
        return this.create(countryCode, areaCode, null);
    }

    public PhoneNumber create(String countryCode, String areaCode, String callbackUrl) {
        RestRequest request = new RestRequest();
        request.resource = "phone_numbers";
        request.addParameter("country_code", countryCode);
        request.addParameter("area_code", areaCode);
        if (callbackUrl != null) {
            request.addParameter("callback_url", callbackUrl);
        }
        return (PhoneNumber)this.client.post(request, PhoneNumber.class);
    }

    public PhoneNumber retrieve(String number) {
        RestRequest request = new RestRequest();
        request.resource = "phone_numbers/" + RestClient.escape(number);
        return (PhoneNumber)this.client.get(request, PhoneNumber.class);
    }

    public Iterable<PhoneNumber> list() {
        return this.list(new HashMap<String, Object>());
    }

    public Iterable<PhoneNumber> list(Map<String, Object> filters) {
        RestRequest request = new RestRequest();
        request.resource = "phone_numbers";
        for (Map.Entry<String, Object> entry : filters.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        return this.client.list(request, PhoneNumber.class);
    }
}

