/*
 * Decompiled with CFR 0.152.
 */
package com.phaxio.repositories;

import com.phaxio.resources.Fax;
import com.phaxio.resources.FileStream;
import com.phaxio.restclient.entities.RestRequest;
import com.phaxio.services.Requests;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class FaxRepository {
    private Requests client;

    public FaxRepository(Requests client) {
        this.client = client;
    }

    public Fax create(Map<String, Object> options) {
        RestRequest request = new RestRequest();
        request.resource = "faxes";
        ArrayList files = new ArrayList();
        for (Map.Entry<String, Object> option : options.entrySet()) {
            if (option.getKey().equals("to[]")) {
                Collection recipients = (Collection)option.getValue();
                for (String recipient : recipients) {
                    request.addParameter((String)option.getKey(), recipient);
                }
                continue;
            }
            if (((String)option.getKey()).equals("content_url[]")) {
                Collection urls = (Collection)option.getValue();
                for (String url : urls) {
                    request.addParameter((String)option.getKey(), url);
                }
                continue;
            }
            if (((String)option.getKey()).equals("file")) {
                files.add(option.getValue());
                continue;
            }
            if (((String)option.getKey()).equals("file[]")) {
                files.addAll((Collection)option.getValue());
                continue;
            }
            request.addParameter((String)option.getKey(), option.getValue());
        }
        boolean multipleFiles = files.size() > 1;
        for (Object file : files) {
            if (file instanceof File) {
                this.addFile((File)file, request, multipleFiles);
                continue;
            }
            if (file instanceof FileStream) {
                this.addFile((FileStream)file, request, multipleFiles);
                continue;
            }
            if (file instanceof String) {
                this.addFile(new File((String)file), request, multipleFiles);
                continue;
            }
            throw new IllegalArgumentException("file must be File, String (file path) or FileStream.");
        }
        Fax fax = (Fax)this.client.post(request, Fax.class);
        fax.setClient(this.client);
        return fax;
    }

    public Fax retrieve(int id) {
        RestRequest request = new RestRequest();
        request.resource = "faxes/" + id;
        return (Fax)this.client.get(request, Fax.class);
    }

    public Iterable<Fax> list() {
        return this.list(new HashMap<String, Object>());
    }

    public Iterable<Fax> list(Map<String, Object> filters) {
        RestRequest request = new RestRequest();
        request.resource = "faxes";
        for (Map.Entry<String, Object> option : filters.entrySet()) {
            request.addParameter(option.getKey(), option.getValue());
        }
        return this.client.list(request, Fax.class);
    }

    public void testReceiveCallback(Map<String, Object> options) {
        RestRequest request = new RestRequest();
        request.resource = "faxes";
        request.addParameter("direction", "received");
        for (Map.Entry<String, Object> option : options.entrySet()) {
            if (option.getKey().equals("file")) {
                this.addFile((File)option.getValue(), request, false);
                continue;
            }
            request.addParameter(option.getKey(), option.getValue());
        }
        this.client.post(request);
    }

    private void addFile(File file, RestRequest request, boolean multiple) {
        try {
            this.addFile(new FileStream(new FileInputStream(file), file.getName()), request, multiple);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addFile(FileStream fileStream, RestRequest request, boolean multiple) {
        String param = multiple ? "file[]" : "file";
        try {
            InputStream inputStream = fileStream.getInputStream();
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            request.addFile(param, bytes, fileStream.getFileName(), null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

