/*
 * Decompiled with CFR 0.152.
 */
package com.phaxio.resources;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.phaxio.entities.Recipient;
import com.phaxio.resources.FaxFile;
import com.phaxio.restclient.entities.RestRequest;
import com.phaxio.services.Requests;
import java.util.Date;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Fax {
    private Requests client;
    private FaxFile file;
    @JsonProperty(value="id")
    public int id;
    @JsonProperty(value="direction")
    public String direction;
    @JsonProperty(value="num_pages")
    public int pageCount;
    @JsonProperty(value="cost")
    public int costInCents;
    @JsonProperty(value="status")
    public String status;
    @JsonProperty(value="is_test")
    public boolean isTest;
    @JsonProperty(value="created_at")
    public Date createdAt;
    @JsonProperty(value="caller_id")
    public String callerId;
    @JsonProperty(value="from_number")
    public String fromNumber;
    @JsonProperty(value="to_number")
    public String toNumber;
    @JsonProperty(value="recipients")
    public List<Recipient> recipients;
    @JsonProperty(value="tags")
    public Map<String, String> tags;
    @JsonProperty(value="error_type")
    public String errorType;
    @JsonProperty(value="error_id")
    public int errorId;
    @JsonProperty(value="error_message")
    public String errorMessage;
    @JsonProperty(value="completed_at")
    public Date completedAt;

    public FaxFile file() {
        if (this.file == null) {
            this.file = new FaxFile(this.id);
            this.file.setClient(this.client);
        }
        return this.file;
    }

    public void setClient(Requests client) {
        this.client = client;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void resend() {
        this.resend(null);
    }

    public void resend(String callbackUrl) {
        RestRequest request = new RestRequest();
        request.resource = "faxes/" + this.id + "/resend";
        if (callbackUrl != null) {
            request.addParameter("callback_url", callbackUrl);
        }
        this.client.post(request);
    }

    public void cancel() {
        RestRequest request = new RestRequest();
        request.resource = "faxes/" + this.id + "/cancel";
        this.client.post(request);
    }

    public void delete() {
        RestRequest request = new RestRequest();
        request.resource = "faxes/" + this.id;
        this.client.delete(request);
    }
}

