/*
 * Decompiled with CFR 0.152.
 */
package com.phaxio.restclient.entities;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class RestResponse {
    private HttpURLConnection conn;
    private int status = 0;
    private String content;
    private Exception exception;
    private JsonNode jsonNode;
    private ObjectMapper objectMapper;
    private byte[] rawBytes;
    private Map<String, List<String>> headers;

    public void setHttpURLConnectionAndRead(HttpURLConnection httpConnection) throws IOException {
        this.conn = httpConnection;
        this.readEntireResponse();
    }

    public String getContentType() {
        return this.headers.get("Content-Type").get(0);
    }

    public int getStatusCode() throws IOException {
        return this.status;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public String getContent() throws IOException {
        if (this.content == null) {
            this.content = new String(this.rawBytes, "UTF-8");
        }
        return this.content;
    }

    public byte[] getRawBytes() throws IOException {
        return this.rawBytes;
    }

    public JsonNode toJson() throws IOException {
        if (this.jsonNode == null) {
            this.jsonNode = this.getMapper().readTree(this.getContent());
        }
        return this.jsonNode;
    }

    public ObjectMapper getMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        return this.objectMapper;
    }

    private void readEntireResponse() throws IOException {
        this.status = this.conn.getResponseCode();
        this.headers = this.conn.getHeaderFields();
        this.rawBytes = IOUtils.toByteArray((InputStream)this.getInputStream());
    }

    private InputStream getInputStream() throws IOException {
        return this.getStatusCode() == 200 || this.getStatusCode() == 201 ? this.conn.getInputStream() : this.conn.getErrorStream();
    }
}

