/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.oss.unbearable.messages;

import com.pingidentity.oss.unbearable.messages.SignatureResult;
import com.pingidentity.oss.unbearable.messages.TokenBindingKeyParameters;
import com.pingidentity.oss.unbearable.utils.EcKeyUtil;
import com.pingidentity.oss.unbearable.utils.In;
import com.pingidentity.oss.unbearable.utils.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;

public class EcdsaP256
extends TokenBindingKeyParameters {
    static final int COORDINATE_LENGTH = 32;
    static final byte[] POINT_LENGTH = new byte[]{64};

    @Override
    PublicKey readPublicKey(In in, int length) throws IOException, GeneralSecurityException {
        byte[] point = in.readOneByteOfBytes();
        byte[] x = Util.leftHalf(point);
        byte[] y = Util.rightHalf(point);
        return EcKeyUtil.p256publicKey(x, y);
    }

    @Override
    public byte[] encodeTokenBindingPublicKey(PublicKey publicKey) {
        ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
        ECPoint ecPoint = ecPublicKey.getW();
        BigInteger xInt = ecPoint.getAffineX();
        byte[] x = Util.toUnsignedMagnitudeByteArray(xInt, 32);
        BigInteger yInt = ecPoint.getAffineY();
        byte[] y = Util.toUnsignedMagnitudeByteArray(yInt, 32);
        return Util.concat(POINT_LENGTH, x, y);
    }

    @Override
    String getJavaAlgorithm() {
        return "SHA256withECDSA";
    }

    @Override
    byte getIdentifier() {
        return 2;
    }

    @Override
    SignatureResult evaluateSignature(byte[] signatureInput, byte[] signature, PublicKey publicKey) throws IOException {
        byte[] convertedSignature = EcdsaP256.convertConcatenatedToDer(signature);
        return super.evaluateSignature(signatureInput, convertedSignature, publicKey);
    }

    @Override
    public byte[] sign(byte[] signatureInput, PrivateKey privateKey) throws GeneralSecurityException {
        byte[] encodedSignatureBytes = super.sign(signatureInput, privateKey);
        try {
            return EcdsaP256.convertDerToConcatenated(encodedSignatureBytes, 64);
        }
        catch (IOException e) {
            throw new GeneralSecurityException("Unable to convert DER encoding to R and S as a concatenated byte array.", e);
        }
    }

    @Override
    String checkPublicKey(PublicKey publicKey) {
        try {
            ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
            ecPublicKey.getParams().getCurve();
        }
        catch (ClassCastException e) {
            return "Wrong key type (expecting EC Public Key): " + e;
        }
        return null;
    }

    private static byte[] convertConcatenatedToDer(byte[] concatenatedSignatureBytes) throws IOException {
        int offset;
        byte[] derEncodedSignatureBytes;
        int len;
        int k;
        int rawLen;
        int i;
        for (i = rawLen = concatenatedSignatureBytes.length / 2; i > 0 && concatenatedSignatureBytes[rawLen - i] == 0; --i) {
        }
        int j = i;
        if (concatenatedSignatureBytes[rawLen - i] < 0) {
            ++j;
        }
        for (k = rawLen; k > 0 && concatenatedSignatureBytes[2 * rawLen - k] == 0; --k) {
        }
        int l = k;
        if (concatenatedSignatureBytes[2 * rawLen - k] < 0) {
            ++l;
        }
        if ((len = 2 + j + 2 + l) > 255) {
            throw new IOException("Invalid format of ECDSA signature");
        }
        if (len < 128) {
            derEncodedSignatureBytes = new byte[4 + j + 2 + l];
            offset = 1;
        } else {
            derEncodedSignatureBytes = new byte[5 + j + 2 + l];
            derEncodedSignatureBytes[1] = -127;
            offset = 2;
        }
        derEncodedSignatureBytes[0] = 48;
        derEncodedSignatureBytes[offset++] = (byte)len;
        derEncodedSignatureBytes[offset++] = 2;
        derEncodedSignatureBytes[offset++] = (byte)j;
        System.arraycopy(concatenatedSignatureBytes, rawLen - i, derEncodedSignatureBytes, offset + j - i, i);
        offset += j;
        derEncodedSignatureBytes[offset++] = 2;
        derEncodedSignatureBytes[offset++] = (byte)l;
        System.arraycopy(concatenatedSignatureBytes, 2 * rawLen - k, derEncodedSignatureBytes, offset + l - k, k);
        return derEncodedSignatureBytes;
    }

    private static byte[] convertDerToConcatenated(byte[] derEncodedBytes, int outputLength) throws IOException {
        int sLength;
        int j;
        int rLength;
        int i;
        int offset;
        if (derEncodedBytes.length < 8 || derEncodedBytes[0] != 48) {
            throw new IOException("Invalid format of ECDSA signature");
        }
        if (derEncodedBytes[1] > 0) {
            offset = 2;
        } else if (derEncodedBytes[1] == -127) {
            offset = 3;
        } else {
            throw new IOException("Invalid format of ECDSA signature");
        }
        for (i = rLength = derEncodedBytes[offset + 1]; i > 0 && derEncodedBytes[offset + 2 + rLength - i] == 0; --i) {
        }
        for (j = sLength = derEncodedBytes[offset + 2 + rLength + 1]; j > 0 && derEncodedBytes[offset + 2 + rLength + 2 + sLength - j] == 0; --j) {
        }
        int rawLen = Math.max(i, j);
        rawLen = Math.max(rawLen, outputLength / 2);
        if ((derEncodedBytes[offset - 1] & 0xFF) != derEncodedBytes.length - offset || (derEncodedBytes[offset - 1] & 0xFF) != 2 + rLength + 2 + sLength || derEncodedBytes[offset] != 2 || derEncodedBytes[offset + 2 + rLength] != 2) {
            throw new IOException("Invalid format of ECDSA signature");
        }
        byte[] concatenatedSignatureBytes = new byte[2 * rawLen];
        System.arraycopy(derEncodedBytes, offset + 2 + rLength - i, concatenatedSignatureBytes, rawLen - i, i);
        System.arraycopy(derEncodedBytes, offset + 2 + rLength + 2 + sLength - j, concatenatedSignatureBytes, 2 * rawLen - j, j);
        return concatenatedSignatureBytes;
    }
}

